<?php
    $lib = dirname(dirname(__FILE__)).'/lib';
    $ip = ini_get ('include_path');
    ini_set ('include_path', "$lib:".$ip);
    include_once "info/func.php";
    
    $self_url = $self;
    // Configuration 
    $up_dir = "documents";
    $up_zones = array(
        'public' => 'docs',
        'etud' =>   'etud/docs', 
        'ens' =>    'ens/docs',
        'admin' =>  'admin/docs',
        // 'support' => 'etud/support'
        );
    $img_ext = '/\.(png|gif|jpg)$/';
    $forbiden_ext = '/\.(php|py|sh)$/';

    /*
     * header and footer ae not used for use in phpCMS
     */
    $header = '<?xml version="1.0" encoding="iso-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr"
    lang="fr" dir="ltr">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
    <title>Gestion des documents du site</title>
    <meta name="Author" content="D.Deveaux" />
    <meta http-equiv="content-type" content="text/html" />
    <link rel="stylesheet" href="'.$base_url.'/ens/style/style.css" type="text/css" />
    <style type="text/css">
    #upload {margin: 1em; padding: 1ex 1em; border: 1px solid black;
             text-align: center; float: right; width: 60%}
    #chgzone, #chgsect {margin: 1em; padding: 0; 
             text-align: center; float: left; width: 25%}
    #chgzone p {margin: 0;}
    .ok, .nok {font-size: 90%; font-weight: bold; width: 100%; padding: 0.3ex;}
    .ok  {background-color: green;}
    .nok {background-color: red;}
    img {border: 0 none transparent; vertical-align: bottom;}
    .text {width: 80%; margin: 1ex auto;}
    </style>
  </head>
  <body>
    ';

    $footer = "  </body>\n</html>\n";
    
//    include_once "info/func.php";
    $args = array();
    foreach (array_keys($_POST) as $k) { $args[$k] = stripslashes($_POST[$k]); }
    foreach (array_keys($_GET) as $k) { $args[$k] = stripslashes($_GET[$k]); }
    // print_r($args); print "<br />";
    if ($args['zone'] == "") { $args['zone'] = 'ens'; }
    $sections = _getCurrentSections();
    if ($args['section'] == "") { $args['section'] = $sections[0]; }
    
    /** build the sections list of the current directory
     */
    function _getCurrentSections() {
        global $args, $up_zones, $dr;
        $curdir = _getCurrentDir('zone');
        $fd = dir($curdir); $rubriques = array();
        while ($entry = $fd->read()){
             if (($entry != ".") && ($entry != "..") && ($entry != "CVS") &&
                 ($entry != ".DAV")) {
                 if(@is_dir("$curdir/$entry")) {
                     $rubriques[$i] = $entry;
                     $i++;
                 }
             }
        }
        $fd->close();
        sort ($rubriques); reset ($rubriques);
        return $rubriques;
    }
    
    /** compute the current working directory
     */
    function _getCurrentDir($level='zone') {
        global $args, $up_zones, $dr;
        if ($level == 'section') {
            $curdir = $dr."/".$up_zones[$args['zone']]."/".$args['section'];
        } else {
            $curdir = $dr."/".$up_zones[$args['zone']];
        }
        return $curdir;
    }
        
    /** add a new section in the current zone
     */
    function addSection() {
        global $args;
        $curdir = _getCurrentDir('zone');
        if (mkdir("$curdir/".$args['newsect'], 0775)) {
            $ret = "<p class='ok'>Section '".$args['newsect'].
                   "' ajoute dans la zone '".$args['zone']."'</p>\n";
            $args['section'] = $args['newsect'];
            $sections = _getCurrentSections();
        } else {
            $ret = "<p class='nok'>ERREUR : Section '".$args['newsect'].
                   "' pas ajoute !!</p>\n";
        }
        return $ret;           
    }
    
    /** add a new section in the current zone
     */
    function delDocument() {
        global $args;
        $curdir = _getCurrentDir('section');
        $docpath = $curdir."/".$args['del'];
        if (file_exists($docpath) and is_writable($docpath)) {
            if (unlink($docpath)) {
                $ret = "<p class='ok'>Document '".$args['del'].
                       "' dtruit dans la section '".$args['section']."'</p>\n";
            } else {
                $ret = "<p class='nok'>ERREUR : inattendue dans la destruction ".
                   "de '".$args['del']."' dans la section '".$args['section'].
                   "' !!</p>\n";
            }
        } else {
            $ret = "<p class='nok'>ERREUR : le document '".$args['del'].
                   "' n'existe pas ou ne peut pas tre dtruit !!</p>\n";
        }
        $args['del'] = "";
        return $ret;           
    }
    
    /** manage the protection of document files
     */
    function protectFile() {
        global $args;
        $curdir = _getCurrentDir('section');
        if ($args['lock'] != '') {
            $doc = $args['lock'];
            $mode = 0440;
        }
        if ($args['unlock'] != '') {
            $doc = $args['unlock'];
            $mode = 0660;
        }
        $docpath = $curdir."/".$doc;
        if (file_exists($docpath)) {
            if (chmod($docpath, $mode)) {
                $ret = "<p class='ok'>Mode du document '$doc' chang en '$mode'.</p>\n";
            } else {
                $ret = "<p class='nok'>ERREUR : inattendue dans le changement de mode ".
                   "de '$doc' dans la section '".$args['section'].
                   "' !!</p>\n";
            }
        } else {
            $ret = "<p class='nok'>ERREUR : le document '$doc' n'existe pas ou ne peut pas tre modifi !!</p>\n";
        }
        $args['lock'] = ""; $args['unlock'] = "";
        return $ret;           
    }
     
    /** copy the uploaded file in the destination with error control
     */
    function uploadProg($source, $base, $destination) {
	$ofile = str_replace('//', '/', $base."/".$destination);
        // print $source." -- "; print_r($_FILES);
        if ( $_FILES[$source]['error'] == 0 ) {
            $done = @copy($_FILES[$source]['tmp_name'], $ofile);
            //$ok_copy = rename($_FILE[$source]['tmp_name'], $ofile);
            //$ok_copy = move_uploaded_file($source, $ofile); 
            if ( $done ) {
                $ret = "<p class='ok'>Fichier '<code>$destination</code>' ".
                       "correctement upload.</p>\n";
            } else {
                $ret = "<p class='nok'>ERREUR: le fichier '<code>$destination".
                       "</code>' n'a pu tre upload!!</p>\n";
            }
        } else {
            $ret = "<p class='nok'>Tentative d'attaque possible : '<code>".
                   $_FILES[$source]."</code>'!!</p>\n";
        }
        return $ret;
    }

    /** manage the file upload return a status message
     */
    function manageUpload() {
        global $args, $up_zones, $dr;
        $df = ( $args['destfile'] == "" ) ? $_FILES['fupload']['name'] : 
                                            $args['destfile'];
        $dest = str_replace('//', '/', $up_zones[$args['zone']].
                                       "/".$args['section']."/".$df);
        $mes = uploadProg('fupload', $dr, $dest);
        return $mes;
    }
    
    /** build the upload form
     */
    function uploadForm() {
        global $args, $self_url, $up_zones;
        $maxsize = get_cfg_var('upload_max_filesize');
        $txt = "<div id='upload'><form action='$self_url' method='post' 
            enctype='multipart/form-data'>
            <p><big>Chargement dans <b><code>/".
            $up_zones[$args['zone']]."/".$args['section']."</code></b></big>
            <br /><br /><em>La taille maximale de fichier chargeable est :
            $maxsize</em><br />
            <input type='hidden' name='action' value='upload' />
            <input type='hidden' name='zone' value='".$args['zone']."' />
            <input type='hidden' name='section' value='".$args['section']."' />
            <input type='hidden' name='del' value='' />
            <input type='hidden' name='lock' value='' />
            <input type='hidden' name='unlock' value='' />
            <input type='hidden' name='newsect' value='' />
            <input type='file' name='fupload' size='25' /><br /><br />
            Nom dans l'espace de diffusion : &nbsp;&nbsp;
            <input type='text' name='destfile' size='15' value=''>
            &nbsp;&nbsp;&nbsp;
            <input type='submit' value='UpLoad' /></p>
            </form></div>";
        return $txt;
    }

    /** form to select the zone
     */
    function selectZoneForm() {
        global $args, $up_zones, $self_url;
        $txt = "<form name='changezone' action='$self_url' method='POST'>\n".
	    "<p style='border: 1px dotted black; padding: 0.2ex 1em;'>
            <input type='hidden' name='section' value='' />
            <input type='hidden' name='del' value='' />
            <input type='hidden' name='newsect' value='' />
            <input type='hidden' name='lock' value='' />
            <input type='hidden' name='unlock' value='' />
	    <b>Zone de diffusion</b> : ".
	    "<select name='zone' onChange='document.changezone.submit();'>\n";
        foreach (array_keys($up_zones) as $r) {
            $txt .= "<option value='$r'";
            if ($args['zone'] == $r) { $txt .= " selected"; }
            $txt .= ">$r -- /".$up_zones[$r]."/</option>\n";
        }
        $txt .= "</select></p>\n</form>\n";
        return $txt;
    }
    
    /** form to select the section
     */
    function selectSectionForm() {
        global $args, $sections, $self_url;
        $txt = "<form name='changesect' action='$self_url' method='POST'>\n".
	    "<p style='border: 1px dotted black; padding: 0.2ex 1ex;'>
            <input type='hidden' name='zone' value='".$args['zone']."' />
            <input type='hidden' name='del' value='' />
            <input type='hidden' name='lock' value='' />
            <input type='hidden' name='unlock' value='' />
	    <b>Section</b> : ".
	    "<select name='section' onChange='document.changesect.submit();'>\n";
        foreach ($sections as $r) {
            $txt .= "<option value='$r'";
            if ($args['section'] == $r) { $txt .= " selected"; }
            $txt .= ">$r/</option>\n";
        }
        $txt .= "</select><br>Nouvelle
                <input type='text' name='newsect' size='15' value=''>
                <input type='button' value='+' 
                onclick='document.changesect.submit();'/></p>\n</form>\n";
        return $txt;
    }
    
    /** shows the files in the current section
     */
    function showFiles() {
        global $args, $base_url, $self_url, $up_zones, $img_ext;
        $curdir = _getCurrentDir('section');
        $cururl = $base_url."/".$up_zones[$args['zone']]."/".$args['section'];
        $ds = opendir($curdir);
        $txt = "<div id='flist'>
               <h2>Liste des documents de <b><code>/".
               $up_zones[$args['zone']]."/".$args['section']."</code></b></h2>
               <ul>\n";
        while ($e = readdir($ds)) {
            $entry = $curdir."/".$e;
            if ( is_file($entry) ) {
                if ( ($e == "index.php") or 
                     (preg_match("/(.desc)$/i", $e))  ) {
                    continue;
                }
                $size_kb = round(filesize($entry)/1024);
                if (is_writable($entry)) {
                    $action = "<a href='$self_url?zone=".$args['zone'].
                       "&section=".$args['section']."&del=$e' ".
                       "onclick=\"return confirm('Dtruire cette entre ?\\n$e')\" ".
                       "onkeypress=\"return confirm('Dtruire cette entre ?\\n$e')\">".
                       "<img src='$base_url/images/del.png' alt='Delete' ".
                       "title='Dtruire l'entre' /></a>&nbsp;".
                       "<a href='$self_url?zone=".$args['zone'].
                       "&section=".$args['section']."&lock=$e' ".
                       "onclick=\"return confirm('Protger cette entre ?\\n$e')\" ".
                       "onkeypress=\"return confirm('Protger cette entre ?\\n$e')\">".
                       "<img src='$base_url/images/lock.png' alt='lock' ".
                       "title='Protger l'entre' /></a>";
                } else {
                    $action = "<a href='$self_url?zone=".$args['zone'].
                       "&section=".$args['section']."&unlock=$e' 
                       onclick=\"return confirm('Dprotger cette entre?\\n$e')\"
                       onkeypress=\"return confirm('Dprotger cette entre?\\n$e')\">".
                       "<img src='$base_url/images/unlock.png' alt='unlock' ".
                       "title='Dprotger l'entre' /></a>";
                }
                if (preg_match($img_ext, $e)) {
                    $size = getimagesize($entry);
                    $dim = $size[0].'x'.$size[1].' -- ';
                    if ($size[0] > 100) {
                        $redim = "width='100' ";
                    } else {
                        if ($size[1] > 70) {
                            $redim = "height='70' ";
                        } else {
                            $redim = '';
                        }
                    }
                    $img = "\n<img src='$cururl/$e' alt='$e' $redim".
                            "style='float: right'/><hr style='clear: right' />";
                } else {
                    $dim = ''; $img = '';
                }
                $txt .= "<li><code><a href='$cururl/$e'>$e</a></code> -- $dim".
                       "$size_kb kB -- $action $img</li>\n";
            } else {
                ; // directories ignored
            }
        }
        $txt .= "</ul>\n";
        return $txt;       
    }
    
    /*
     *  main routine
     */
    //$txt = $header;
    $txt = '';
    if ( $args['newsect'] != "" ) {
        $txt .= addSection();
    }
    if ( $args['lock'] != "" or $args['unlock'] != "") {
        $txt .= protectFile();
    }
    if ( $args['del'] != "" ) {
        $txt .= delDocument();
    }
    if ( $args['action'] == "upload" ) {
        $txt .= manageUpload();
    }
    $txt .= "<div id='action'>\n";
    $txt .= "<div id='chgzone'>";
    $txt .= selectZoneForm();
    $txt .= selectSectionForm();
    $txt .= "</div>\n";
    $txt .= uploadForm();
    $txt .= "<hr />\n</div>\n";
    $txt .= showFiles();
    //$txt .= $footer;
    
    print $txt;

?>

