<?php
    $lib = dirname(dirname(__FILE__)).'/lib';
    $ip = ini_get ('include_path');
    ini_set ('include_path', "$lib:".$ip);

    include_once "info/func.php";
    require_once "xml/collection.php";

    if ( strcmp(PHP_VERSION, '4.3.0') < 0 ) {
        include_once "Compat/Function/file_get_contents.php";
    }
    
    $news_base = "$info_data/news";

    $eltkey = stripslashes($_GET['key']);

    /* build the categories index */
    $txt = file_get_contents("$news_base/categories.dat");
    $lines = explode("\n", $txt);
    $cat_id = array();
    foreach ( $lines as $line ) {
        if ( $key ) {
            list ($key, $cat_lib) = explode("::", $line);
            $cat_id[$key] = $cat_lib;
        }
    }

    /* get the information on the element */
    $cfile = "$news_base/news.xml";
    $col =& new XmlCollection ($cfile);
    $current =& $col->getAnElt($eltkey);
    $img = $current->valueAt('url_image');
    $pj = $current->valueAt('url_pj');
    
    /* and compose the text of the page */
    
    $txt = "<?xml version='1.0' encoding='iso-8859-1'?>
<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN'
       'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
  <title>News du Dpartement Info</title>
  <link rel='stylesheet' href='../style/style.css' type='text/css' />
</head>
<body>
<div class='text'>\n";
    $tmpl = "<p class='center'>Catgorie : <em>*cat*</em></p>".
            "<p style='float: right; text-align: right;'>".
            "<small><em>Post le *date*<br />\n".
            "par <a href='mailto:*email*'><b>*auteur*</b></a></em></small>";
    if ( $img ) {
        $tmpl .= "<br />\n<img alt='$img' src='$img' />";
    }
    $tmpl .= "</p>\n<dl><dt>*titre*</dt>\n<dd>*texte*\n";
    if ( $pj ) {
        $tmpl .= "<hr width='20%' align='left'/>\n".
                 "<a href='*url_pj*' target='_blank'>Pice jointe</a>\n";
    }
    $tmpl .= "</dd></dl>\n";
    $txt .= $col->showEltTmpl($eltkey, $tmpl);
    $txt .= "</div>\n</body>\n</html>\n";

    print $txt;

?>

