<?php
    $lib = dirname(dirname(__FILE__)).'/lib';
    $ip = ini_get ('include_path');
    ini_set ('include_path', "$lib:".$ip);

    include_once "info/func.php";
    require_once "xml/collection.php";

    if ( strcmp(PHP_VERSION, '4.3.0') < 0 ) {
        include_once "Compat/Function/file_get_contents.php";
    }
    
    $news_base = "$info_data/news";

    $args = array();
    foreach (array_keys($_POST) as $k) {
        $args[$k] = stripslashes($_POST[$k]);
    }
    $cat = $args['cat'];

    /* build the categories index */
    $txt = file_get_contents("$news_base/categories.dat");
    $lines = explode("\n", $txt);
    $cat_id = array();
    foreach ( $lines as $line ) {
	list ($key, $cat_lib) = explode("::", $line);
        if ( !$cat ) { $cat = $key; }
	$cat_id[$key] = $cat_lib;
    }

    /* handle a new category */
    if ( $args['newcat'] != '' ) {
	$cat = strtolower($args['newcatcode']);
	$cat_id[$cat] = $args['newcat'];
	// save the file 'categories.dat'
	ksort($cat_id);
	reset($cat_id);
	$fw = fopen ("$news_base/categories.dat", "w");
	while (list ($key, $val) = each ($cat_id)) {
	    if ( $key != '' ) { fwrite ($fw, "$key::$val\n"); }
	}
	fclose($fw);
    }

    /* handle the addition of a new */
    if ( $args['auteur'] && $args['titre'] ) {
	$cfile = "$news_base/news.xml";
        $col =& new XmlCollection ($cfile);
	$datem = (string)time();
	$items = array ($datem, $args['auteur'], $args['email'], 
                        $args['vis'], $args['cat'], $args['titre'],
                        $args['accro'], $args['texte'], $args['url_image'], 
                        $args['url_pj'], 'oui');
	$newkey = str_replace(" ", '_', str_replace(".", "_", 
                               str_replace("/", "_", $datem.$args['auteur']))); 
        $catlib = $cat_id[$cat];
	$col->createElt ($newkey, $items);
	$col->saveFile();
	$add_txt = "<p class='center'><span class='green'>Nouvelle <q>".$args['titre']."</q><br/>".
                   "ajoute dans la catgorie <q>$catlib</q>.</span></p>\n";
	$args['newcat'] = '';
	$args['newcatcode'] = '';
        $args['auteur'] = '';
        $args['email'] = '';
        $args['vis'] = '';
        $args['cat'] = '';
        $args['titre'] = '';
        $args['accro'] = '';
        $args['texte'] = '';
        $args['url_image'] = '';
        $args['url_pj'] = '';
    } else { $add_txt = ''; }

    /* and compose the text of the page */
    $txt = "<?xml version='1.0' encoding='iso-8859-1'?>
<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN'
       'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
  <title>Les nouvelles du dpartement</title>
  <link rel='stylesheet' href='../style/style.css' type='text/css' />
</head>
<body>
<div class='text'>
<h2 class='center'>Ajout d'une nouvelle</h2>
<hr style='width: 40%; text-align: center' />
";
    $txt .= $add_txt;
    $txt .= "<form name='saisie' action='$self' method='post'>
 <table width='85%' style='margin: 1ex auto'>
  <colgroup><col width='45%' align='right'/><col width='55%' /></colgroup>
  <tbody>
   <tr>
    <td>Catgorie :</td>
    <td>
     <select name='cat' style='width: 25em'>\n";
    while (list ($key, $val) = each ($cat_id)) {
	if ( $key != '' ) {
	    $txt .= "<option value='$key'";
            if ( $key == $cat ) { $txt .= " selected"; }
	    $txt .= ">$val</option>\n";
	}
    }
    $txt .= "     </select>
    </td>
   </tr><tr>
    <td>et/ou nouvelle catgorie :</td>
    <td><input type='text' size='40' name='newcat' value='".$args['newcat']."' /></td>
   </tr><tr>
    <td>code de cette catgorie :</td>
    <td><input type='text' size='6' name='newcatcode' value='".$args['newcatcode']."' /></td>
   </tr><tr>
    <td>Visibilit :</td>
    <td>
     <select name='vis' style='width: 10em'>
       <option value='public' selected>public</option>
       <option value='etud'>etud</option>
       <option value='ens'>ens</option>
     </select>
    </td>
   </tr><tr>
    <td>Propos par :</td>
    <td><input type='text' size='25' name='auteur' value='".$args['auteur']."' /></td>
   </tr><tr>
    <td>Courriel :</td>
    <td><input type='text' size='25' name='email' value='".$args['email']."' /></td>
   </tr><tr>
    <td>Titre de la nouvelle (ne pas dborder SVP) :</td>
    <td><input type='text' size='40' name='titre' value='".$args['titre']."' /></td>
   </tr><tr>
    <td>Texte d'accroche (ne pas dborder SVP) :</td>
    <td><textarea cols='40' rows='2' name='accro'>".$args['accro']."</textarea></td>
   </tr><tr>
    <td>Texte de la nouvelle : </td>
    <td><textarea cols='40' rows='8' name='texte'>".$args['texte']."</textarea></td>
   </tr><tr>
    <td>URL de l'image jointe :</td>
    <td><input type='text' size='30' name='url_image' value='".$args['url_image']."' /></td>
   </tr><tr>
    <td>URL de pice jointe : </td>
    <td><input type='text' size='30' name='url_pj' value='".$args['url_pj']."' /></td>
   </tr>
  </tbody>
 </table>
 <p class='center'><input type='submit' value='Valider' /></p>
</form>";

    $txt .= "<p class='center'><b>[<a ".
	    "href='$phpurl/oldnews.php'>Voir la liste des nouvelles</a>]</b></p>\n";
    $txt .= "</div>\n</body>\n</html>\n";

    print $txt;


?>

