<?php
    $phpdir = $_SERVER['DOCUMENT_ROOT'].'/include';
    include_once ("$phpdir/pes/func.php");
    require ("$phpdir/fpdf152/fpdf.php");

class PES_DOC extends FPDF {
    var $encHeaders = 0;	// encadrement des headers et footers
    //En-tte
    function Header() {
	global $document_root;
        //Logo
        $this->Image ("$document_root/images/logoPES-small.png", 10, 10, 30 );
        //Police Arial gras 15
        $this->SetFont ('Times', '', 12 );
        //Dcalage  droite
        /*	$this->Cell (80);*/
        //Titre
        $this->Cell (0, 16, 'Animation Musiques, Danses et Culture de Bretagne', $this->encHeaders, 1, 'R' );
        //Espace de 5mm sous le header
        $this->Ln (5 );
    }

    //Pied de page
    function Footer() {
        //Positionnement  1,5 cm du bas
        $this->SetY (-15 );
        //Police Arial italique 8
        $this->SetFont ('Arial', '', 8 );
        //Numro de page
        $this->Cell (0, 10, 'Page '.$this->PageNo().'/{nb}', $this->encHeaders, 0, 'C' );
    }

    // Titre de document
    function Title ($title ) {
        //Police Arial gras 18
        $this->SetFont ('Arial', 'B', 20 );
        // Cadre du titre
        $this->Cell (0, 25, $title, $this->encHeaders, 1, 'C' );
    }

    // Affichage une ligne horizontale
    function Hr ($size=100) {
	$width = 190 * $size / 100;
        $margin = 10 + ((190 - $width) / 2);
        // cadre d'identification du document
	$this->Ln (3);
	$this->SetX ($margin);
        $this->Cell ($width, 0, '', 1, 1);
	$this->Ln (5);
    }

    // Affichage identification
    function Ident ($id, $date ) {
        //Police Arial italique 12
        $this->SetFont ('Arial', 'IU', 9 );
        // cadre d'identification du document
        $this->Cell (0, 6, $id.' du '.$date, $this->encHeaders, 1, 'L' );
    }

    // Affichage une valeur avec son label
    function Info ($label, $value, $saut=true, $pos1=0, $pos2=0, $gras=true) {
	if ( $pos1 != 0 )	{ $this->SetX ($pos1); }
	if ( $saut )		{ $value = $value . "\n"; }
	$this->write (5, "$label : ");
	if ( $gras )		{ $this->SetFont ('','B'); }
	if ( $pos2 != 0 )	{ $this->SetX ($pos2); }
	$this->write (5, "$value");
	$this->SetFont ('','');
    }

    // Affichage un paragraphe avec son label
    function Para ($label, $value, $saut=true, $pos1=0, $pos2=0, $gras=false) {
	if ( $pos1 != 0 )	{ $this->SetX ($pos1); }
	if ( $saut )		{ $value = $value . "\n"; }
	$this->write (5, "$label : ");
	if ( $gras )		{ $this->SetFont ('','B'); }
	if ( $pos2 != 0 )	{ $margin = $pos2; }
	else { $margin = $this->GetX() + 5; }
	$this->SetLeftMargin ($margin);
        $this->SetX ($margin);
	$this->SetFont ('','',9);
	$this->write (5, "$value");
	$this->SetLeftMargin (25);
	$this->SetFont ('','',12);
    }

    // Affiche un texte encadr
    function Cadre ($text, $height, $margin=35, $padding=4) {
	$width = 210 - ($margin * 2);
	$this->Ln (3);
	$curY = $this->GetY();
	$this->SetX ($margin);
	$this->Cell ($width, $height, '', 1, 1);
	$this->Ln (3);
	$nextY = $this->GetY();
	$this->SetY ($curY + ($padding / 2));
	$this->SetLeftMargin ($margin + $padding);
	$this->SetRightMargin ($margin + $padding);
	$this->SetFont ('','', 10);
	$this->write (5, "$text\n");
	$this->SetFont ('','', 12);
	$this->SetLeftMargin (25);
	$this->SetRightMargin (25);
	$this->SetY ($nextY);
    }

    // Signature
    function Signe ($fact=false) {
        //Police Arial italique 12
        $this->SetFont ('Arial', 'I', 10 );
        // cadre d'identification du document
	if ( !$fact ) {
	    $this->Ln (15);
	    $this->SetX (40);
	    $this->Cell (135, 0, '', 1, 1);
	}
	$this->Ln (5);
	$this->SetX (65);
	if ( $fact ) {
	    $this->write (5, "Fait le ___________________\nLa trsorire");
	} else {
	    $this->write (5, 'Pour PES');
	    $this->SetX (120);
	    $this->write (5, 'Pour le client');
	}

    }

    // Affichage tableau partenaires
    function Entre ($fac, $pesr, $client, $corres, $adr ) {
        //Police de base
        $this->SetFont ('Times', '', 11 );
        // D'abord le cadre
	$curY = $this->GetY();
	$this->Ln (2);
	$this->setX (25);
	$this->SetLineWidth (0.4);
        $this->Cell (80, 30, '', 1, 0);
	$this->Cell (80, 30, '', 1, 1);
	$this->SetLineWidth (0.2);
	$this->Ln (2);
	$nextY = $this->GetY();
	if ($fac) {
	    $l11 = "metteur :\n";
	    $l12 = "Dbiteur :\n";
	    $l31 = "Trsorire : ";
	    $l32 = "" ;
	} else {
	    $l11 = "Entre :\n";
	    $l12 = "Et :\n";
	    $l31 = "rprsent par : ";
	    $l32 = "rprsent par : " ;
	}
	// Ecriture PES
	$this->SetLeftMargin (27);
	$this->SetRightMargin (102);
	$this->SetY ($curY + 3);
	$this->write (4, $l11);
	$this->SetFont ('','B');
	$this->write (4, "Association Pouvr'et Seu\n");
	$this->SetFont ('','');
	$this->write (4, $l31);
	$this->SetFont ('','B');
	$this->write (4, "$pesr\n");
	$this->SetFont ('','');
	$this->write (4, "Le Houssais\n44390 SAFFR\n");
	$this->write (4, "Tel: 02 40 77 20 24 - 02 97 46 05 00\n");
	$this->write (4, "email: pouevretseu@free.fr\n");
	// Ecriture Client
	$this->SetLeftMargin (107);
	$this->SetRightMargin (28);
	$this->SetY ($curY + 3);
	$this->write (4, $l12);
	$this->SetFont ('','B');
	$this->write (4, "$client\n");
	$this->SetFont ('','');
	$this->write (4, $l32);
	$this->SetFont ('','B');
	$this->write (4, "$corres\n");
	$this->SetFont ('','');
	$this->write (4, $adr);
	// Retour  la normale
	$this->SetLeftMargin (10);
	$this->SetRightMargin (10);
	$this->SetY ($nextY + 5);
    }

    // dbut du tableau de facture
    function EntFact ($t1, $t2) {
	$this->Ln (3);
	$this->setX (40);
	$this->setFont ('', 'B');
	$this->Cell (100, 8, $t1, 1, 0, 'C');
	$this->Cell (30, 8, $t2, 1, 1, 'C');
	$this->setFont ('', '');
    }

    // ligne courante du tableau de facture
    function LnFact ($t1, $t2) {
	$y = $this->GetY ();
	$this->SetX (40);
	$this->MultiCell (100, 5, "  $t1", 'LR', 'J', 0);
	$h = $this->GetY() - $y;
	$this->SetY ($y); $this->SetX (140);
	$this->Cell (30, $h, "$t2  ", 'LR', 1, 'R');
    }

    // ligne Total du tableau de facture
    function TotFact ($t) {
	$this->setX (40);
	$this->setFont ('', 'B');
	$this->Cell (100, 8, "  Total", 1, 0, 'L');
	$this->Cell (30, 8, "$t  ", 1, 1, 'R');
 	$this->setFont ('', '');
    }

}
/*
// Test de la classe
$pdf = new PES_DOC();
$pdf->Open();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->Title ('Convention de prestation' );
$pdf->Ident ('Convention 2002-02', '10/06/2002' );
$pdf->Entre (false, 'D.Deveaux', "Association Culturelle de l'IUT",
            'M.Kervadec', "IUT de Vannes\n8,rue Montaigne\n56000 VANNES");
$pdf->Entre (true, 'D.Deveaux', "Association Culturelle de l'IUT",
            'M.Kervadec', "IUT de Vannes\n8,rue Montaigne\n56000 VANNES");
$pdf->SetLeftMargin (25);
$pdf->SetRightMargin (25);
$pdf->SetFont ('Times', '', 12 );
$pdf->Cell (50, 10, 'Texte du document ici'.$i, 0, 1 );
$pdf->Output ('test.pdf', false);
$pdf->Output();
*/
?>
