#!/usr/local/bin/perl
#
#	links.pl		<role>
#
#	$Id: links.pl,v 1.1 2005/06/09 11:58:39 deveaux Exp $
#
# ----------------------------------------------------------------------

#=com ---Identification ------------------------------------------------
#
#|      nom             links
#|      role            <role>
#|      projet          webTools
#
#=com I <lsd=webTools.lsdi>
#=com ---Adresse -------------------------------------------------------
#
#|      copyr           Copyright (c) 1998-99 - U.B.S.
#|      patron
#|      auteur          D.Deveaux
#|      org
#|      service
#|      adresse
#|      mailorg
#|      http
#
#=com ---Caractrisation de page ---------------------------------------
#
#|      type            man
#|      parent
#|      section         3pm
#|      icone
#
#=com ---Dernire modification -----------------------------------------
#
#
#|	lastm		Cration de la classe
#|	maj		2000/10/30
#|	redacteur	=auteur
#|	mailto		deveauxd@iu-vannes.fr
#|	audit		
#|	etat		exp
#=com			exp(rimental), alpha, beta, stable, vers(ionn)
#|	fichier		$Source: /data/db/CVSMaster/extrainfo/site-cms/links.pl,v $
#|	date		$Date: 2005/06/09 11:58:39 $
#|	revision	$Revision: 1.1 $
#
#=com ------------------------------------------------------------------
#
#|HTML|I<tdm=>
#
#=sec	Nom
#
#I<parNom=>
#
#=com           Titres des extractions
#
#|MAN|Page de manuel
#
#|IMPL|Implmentation du script
#
#=com ------------------------------------------------------------------
#
#=sec|MAN,IMPL|	Appel
#
#	links ...
#
#
#=sec|MAN|	Description
#
#
#=sec|MAN|	Options
#
#=val	--<opt>		:  <role-opt>
#    			  
#=sec|MAN,IMPL|	Paramtrage
#
#
#=sec|MAN,IMPL|	Fichier
#
#
#=sec|IMPL|	Implmentation du script
#
#
#=cut
#
# ----------------------------------------------------------------------
#
    require	5.003 ;

    #
    #=ssec|IMPL|	Clientles
    #==
#    use		MaP ;
    use		Getopt::Long ;
    use		File::Basename ;
    use		File::Find ;
    use		IO::File ;

    #==
    #=ssec|IMPL|	Variables partages du script
    #
    #==
    $show = 0 ;			#  contle de visualisation
    $verbeux = 1 ;		#  contrle le mode verbeux
    @FindedLinks = () ;		#  accumulation des liens

    #==
    #
    #=ssec|IMPL|	Procdures locales au script
    #
    #=cut
    #	Procedure d'aide en ligne --------------------------------------
    #
    sub	aide	{
	my	($shap, $shop, $ret) = @_ ;
	my	$com = basename ($0, '.pl') ;
	if  ( (not $shop) and (not $shap) ) {
	    print "\n$com\n\n    Role\n".
# role du script
    "	Gre les liens d'un projet\n".
    "	Suivant l'option, il affiche la liste, la stocke dans un fichier,\n".
    "	prsente les liens nouveaux depuis la dernire sauvegarde ou ".
    "rgnre\n\tles liens  partir du fichier.\n".
    "	La rgnration permet de redfinir les liens sur la nouvelle\n".
    "	adresse aprs le dplacement d'un volume de projet.\n".
    "	Les options permettent de dfinir le nom du fichier de sauvegarde\n" .
    "	et le nom du rpertoire de base du projet\n".
    "\n" .
    "    Appel\n" ;
	    }
	if  ( (not $shop) ) {
	    print <<"COMAPP" ;
	$com [<options>] show|new|save|restore [<rep>]
COMAPP
	    }
	if  ( (not $shop) and (not $shap) ) {
	    print "\n    Options\n" ;
	    }
	if  ( (not $shap) ) {
	    print <<"OPTS" ;
	--file=<nom>	:  nom du fichier de sauvegarde ('.links' par dfaut)
	--basedir=<dir>	:  rpertoire de base du projet (par dfaut le 
			   rpertoire analys)
        show		:  affiche la liste  l'cran
        new		:  montre les nouveaux liens (le fichier de sauvegarde
			   doit exister)
	save		:  sauvegarde les liens dans un fichier
	restore		:  restauration des liens sauvegards (relocation)
	<rep>		:  rpertoire de projet  analyser ('.' par dfaut)

OPTS
	    }
	exit ($ret) ;
    }

    #
    #=com --- Autres procdures du script ----------------------------------
    #

    #=proc|IMPL|	verbMsg()	:  message en mode verbeux
    #==
    #	verbMsg ($message) ;
    #==
    #=cut
    sub	verbMsg	{
	my	($mes) = @_ ;

	print	STDERR	"\t- $mes\n" 		if ( $verbeux ) ;
    }
    #=fproc -------------------------------------------- verbMsg()


    #=fonc|IMPL|	error()	:  gre un message d'erreur
    #
    #	Ecrit un message d'erreur sur le STDERR et arrte ventuellement
    #	le programme.
    #	Le comportement dpend du prfixe du message :
    #	- `!!` : erreur fatale, message `ERREUR : ...` et arrt,
    #	- `!`  : erreur non fatale, message `ERREUR : ...`,
    #   - <autre> : message `WARNING : ...`.
    #	-
    #==
    #	error ($message) ;
    #==
    #=cut
    sub	error	{
	my	($message) = @_ ;

	if ( $message =~ s/^!!// ) {
	    print STDERR "\nERREUR : $message\n\n" ;
	    exit (1) ;
	} elsif ( $message =~ s/^!// ) {
	    print STDERR "\nERREUR : $message\n\n" ;
	} else {
	    print STDERR "WARNING : $message\n\n" ;
	}					#  if ( $Verbeux )
    }
    #=ffonc -------------------------------------------- error()

    #=proc|IMPL|	wanted()  :  routine d'excution de find
    #==
    #	find (\&wanted, ...) ;
    #==
    #=cut
    sub wanted {
	-l && push @FindedLinks, $File::Find::name ;
    }
    #=fproc -------------------------------------------- wanted()

    #=proc|IMPL|	listLinks()  :  oprations de listage
    #==
    #	find (\&wanted, ...) ;
    #==
    #=cut
    sub listLinks {
	my $mode = shift ;
	my $dir = shift ;
	my $baseDir = shift ;
	my $linksFile = shift ;
	
	my ($date, $fh, $cible, @tab) ;
	
    	find (\&wanted, $dir) ;
    
    	if ( not scalar @FindedLinks ) {
            print "\n    Aucun lien dans $dir\n\n" ;
            return (0) ;
    	}					#  if ( not scalar ...
    	$date = `date "+%Y/%m/%d-%H:%M:%S"` ; chomp $date ;
   	print "\nNouveaux liens de $dir :\n\n" 	if ( $mode eq 'new' ) ;
    	print "\nLiens de $dir :\n\n" 		if ( $mode eq 'show' ) ;
    	print "  <Current> => $dir\n  <BD>  =>  $baseDir\n  <Date>  =>  ".
		  time ."($date)\n"		if ( $mode eq 'show' ) ;
    	if ( $mode eq 'save' ) {
            $fh = new IO::File ("> $linksFile") ;
            if ( defined $fh ) {
    	    	$fh->print ("<Current> => $dir\n<BD>  =>  $baseDir\n".
		        "<Date>  =>  ".time ."($date)\n") ;            
            } else {
            	error ("!!Ecriture de '$linksFile' impossible") ;
            }					#  if ( defined $fh )
    	}					#  if ( $mode eq 'file' )
     	foreach	$lnk	( @FindedLinks ) {
            $lnk =~ s:^$dir/:: ;
	    $cible = readlink ("$dir/$lnk") ;
	    $cible =~ s/^$baseDir/<BD>/ ;
            print "  $lnk  =>  $cible\n"	if ( $mode eq 'show' ) ;
            $fh->print ("$lnk  =>  $cible\n")	if ( $mode eq 'save' ) ;
            if ( $mode eq 'new' ) {
            	@tab = lstat "$dir/$lnk" ;
            	if ( $mtime < $tab[9] ) {
                    print "  $lnk  =>  $cible\n" ;
            	}				#  if ( $age > -M "$dir/$lnk" )
            }					#  if ( $mode eq 'new' )
    	}					#  foreach $lnk
    	if ( $mode eq 'save' ) {
	    $fh->close ;
	    print "\n\tFichier '$linksFile' crit sur '$dir'\n" ;
    	}					#  if ( $mode eq 'file' ) 
	return 1 ;
    }
    #=fproc -------------------------------------------- listLinks()

    #=proc|IMPL|	restoreLinks()  :  oprations de listage
    #==
    #	
    #==
    #=cut
    sub restoreLinks {
	my $dir = shift ;
	my $linksFile = shift ;
	
	my ($fh, @lines, $line, $link, $cible, $nlinks) ;
	
        $fh = new IO::File ("< $linksFile") ;
        if ( defined $fh ) {
    	    print "\n    Restauration de '$dir'\n".
		  "       partir de '$dir/$linksFile'\n" ;
        } else {
            error ("!!Fichier '$linksFile' illisible") ;
        }					#  if ( defined $fh )
        @lines = $fh->getlines ;
        $fh->close ;
        $nlinks = 0 ;
     	foreach	$line	( @lines ) {
     	    $line =~ m/(.*?)\s+=>\s+(.*)$/ ;
     	    $link = $1 ; $cible = $2 ;
     	    if ( $link =~ m/<(Current|BD|Date)>/ ) {
     	        next ;
     	    } else {
     	        $cible =~ s/<BD>/$dir/ ;
     	        unlink $link		if ( -l $link ) ;
     	        symlink $cible, $link ;
     	        $nlinks++ ;
     	    }					#  if ( $link =~ ...
    	}					#  foreach $line
    	print "      $nlinks liens rtablis\n" ;
	return 1 ;
    }
    #=fproc -------------------------------------------- restoreLinks()

    #
    #=sec|IMPL|	Excution de la commande
    #
    #=cut
	
    #
    #	Analyse des options
    #
    $baseDir = '' ; $aide = $shap = $shop = 0 ;
    $linksFile = '.links' ;
    if ( not GetOptions (
    	    'shap!'		=>  \$shap,	#  controle d'aide pour
    	    'shop!'		=>  \$shop,	#   documentation automatique
	    'aide|help'		=>  \$aide, 	#  aide en ligne
	    'basedir=s'		=>  \$baseDir,	#  rpertoire de base
	    'file=s'		=>  \$linksFile,#  fichier des liens
	    'verb!'		=>  \$verbeux	#  mode verbeux
	    ) )	{
	error "!option incorrecte" ;
	aide (0, 0, 1) ;
    }						#  if ( GetOptions ...
    aide (0, 0, 0)			if ( $aide ) ;
    
    $mode = shift ;
    if ( $mode !~ m/(show|new|save|restore)/ ) {
        error ("!le premier argument doit tre 'show', 'new' ou 'file'") ;
        aide (0, 0, 1) ;
    }						#  if ( $mode !~ ...
    
    
    #
    #    ....
    #
    $dir = shift ;
    $dir = "."			unless ( $dir ) ;
    chdir  $dir ;
    $dir = `pwd` ; chomp $dir ;
    $baseDir = $dir		unless ( $baseDir ) ;

    if ( $mode eq 'new' ) {
        if ( -r $linksFile ) {
            @tab = stat $linksFile ;
            $mtime = $tab[9] ;
        } else {
            error ("!!Le fichier '$dir/$linksFile'\n".
		   "         doit exister pour excuter ce mode") ;
        }					#  if ( -r $linksFile )
    }						#  if ( $mode eq 'new' )
    
    
    if ( $mode eq 'restore' ) {
        $ret = restoreLinks ($dir, $linksFile);
    } else {
        $ret = listLinks ($mode, $dir, $baseDir, $linksFile) ;
    }						#  if ( $mode eq 'restore' )
    print "\n" ;

    exit ($ret)
 
#
#=sec|MAN|	Exemples
#
#	links ....
#
#=sec|MAN|	Voir aussi
#
#	
#=sec|MAN|	Diagnostics
#
#
#=sec|MAN,IMPL|	Erreurs connues
#
#
#=sec|LaTeX,LSD,POD|	Auteur
#
#I<parAuteur=>
#
#=fin
#
# ---------------------------------------- Script links
#
#=com ---Histoire des modifications ------------------------------------
#
#	modification history
#	--------------------
#	$Log: links.pl,v $
#	Revision 1.1  2005/06/09 11:58:39  deveaux
#	ajout_saisie_uf
#	
#	Revision 1.2  2002/09/16 12:46:30  le_camj
#	n'utilise pas le module MaP (mis en commentaire)
#	
#	Revision 1.1.1.1  2002/07/11 07:44:20  deveaux
#	repository creation
#	
#	Revision 1.1  2002/03/18 09:57:34  deveaux
#	links handling
#	


