<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:n="http://www.xemelios.org/namespaces#cg-1.0" xmlns:exo="http://exomile.org" xmlns:doccfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" version="2.0">

    <xsl:function name="n:translateEtatToCode">
        <xsl:param name="etat"/>
        
        <xsl:choose>
            <xsl:when test="$etat = 'Accueil'"><xsl:value-of select='$ELEMENT_ACCUEIL' /></xsl:when>
            <xsl:when test="$etat = 'BILAN'"><xsl:value-of select='$ELEMENT_PAGE_BILAN' /></xsl:when>
            <xsl:when test="$etat = 'BILANSYNTH'"><xsl:value-of select='$ELEMENT_PAGE_BILAN_SYNTHETIQUE' /></xsl:when>
            <xsl:when test="$etat = 'CPTRES'"><xsl:value-of select='$ELEMENT_PAGE_COMPTE_RESULTAT' /></xsl:when>
            <xsl:when test="$etat = 'CPTRESSYNTH'"><xsl:value-of select='$ELEMENT_PAGE_COMPTE_RESULTAT_SYNTHETIQUE' /></xsl:when>
            <xsl:when test="$etat = 'ETATCTRLCPT'"><xsl:value-of select='$ELEMENT_PAGE_ETAT_DU_CONTROLE_DES_COMPTES' /></xsl:when>
            <xsl:when test="$etat = 'EXDEPFONC'"><xsl:value-of select='$ELEMENT_PAGE_DEPENSES_DE_FONCTIONNEMENT_COMPT' /></xsl:when>
            <xsl:when test="$etat = 'EXDEPINV'"><xsl:value-of select='$ELEMENT_PAGE_DEPENSES_D_INVESTISSEMENT_COMPT' /></xsl:when>
            <xsl:when test="$etat = 'EXRECFONC'"><xsl:value-of select='$ELEMENT_PAGE_RECETTES_DE_FONCTIONNEMENT_COMPT' /></xsl:when>
            <xsl:when test="$etat = 'EXRECINV'"><xsl:value-of select='$ELEMENT_PAGE_RECETTES_D_INVESTISSEMENT_COMPT' /></xsl:when>
            <xsl:when test="$etat = 'EXDEPEXP'"><xsl:value-of select='$ELEMENT_PAGE_DEPENSES_D_EXPLOITATION_COMPT' /></xsl:when>
            <xsl:when test="$etat = 'EXRECEXP'"><xsl:value-of select='$ELEMENT_PAGE_RECETTES_D_EXPLOITATION_COMPT' /></xsl:when>
            <xsl:when test="$etat = 'EXFCTDEPFONC'"><xsl:value-of select='$ELEMENT_PAGE_DEPENSES_DE_FONCTIONNEMENT_FONCTION_COMPT' /></xsl:when>
            <xsl:when test="$etat = 'EXFCTDEPINV'"><xsl:value-of select='$ELEMENT_PAGE_DEPENSES_D_INVESTISSEMENT_FONCTION_COMPT' /></xsl:when>
            <xsl:when test="$etat = 'EXFCTRECFONC'"><xsl:value-of select='$ELEMENT_PAGE_RECETTES_DE_FONCTIONNEMENT_FONCTION_COMPT' /></xsl:when>
            <xsl:when test="$etat = 'EXFCTRECINV'"><xsl:value-of select='$ELEMENT_PAGE_RECETTES_D_INVESTISSEMENT_FONCTION_COMPT' /></xsl:when>
            <xsl:when test="$etat = 'ANNEXE'"><xsl:value-of select='$ELEMENT_PAGE_ANNEXES' /></xsl:when>
            <xsl:when test="$etat = 'INFOSTATFIN'"><xsl:value-of select='$ELEMENT_PAGE_INFORMATIONS_STAT_FISCALES_FINANCIERES' /></xsl:when>
            <xsl:when test="$etat = 'PRESGENCPT'"><xsl:value-of select='$ELEMENT_PAGE_PRESENTATION_GENERALE_COMPTE_FINANCIER' /></xsl:when>
            <xsl:when test="$etat = 'RESCUMUL'"><xsl:value-of select='$ELEMENT_PAGE_DETERMINATION_RESULTAT_CUMULE' /></xsl:when>
            <xsl:when test="$etat = 'LISTORGAREG'"><xsl:value-of select='$ELEMENT_PAGE_LISTE_ORGANISMES_REGROUPEMENT' /></xsl:when>
            <xsl:when test="$etat = 'LISTETATPUB'"><xsl:value-of select='$ELEMENT_PAGE_LISTE_ETABLISSEMENTS_PUBLICS_CREES' /></xsl:when>
            <xsl:when test="$etat = 'LISTSRVINDIV'"><xsl:value-of select='$ELEMENT_PAGE_LISTE_SERVIVES_INDIVIDUALISES' /></xsl:when>
            <xsl:when test="$etat = 'RSTREALDEP'"><xsl:value-of select='$ELEMENT_PAGE_RESTE_A_REALISER_DEPENSES' /></xsl:when>
            <xsl:when test="$etat = 'RSTREALREC'"><xsl:value-of select='$ELEMENT_PAGE_RESTE_A_REALISER_RECETTES' /></xsl:when>
            <xsl:when test="$etat = 'TAUXCTRB'"><xsl:value-of select='$ELEMENT_PAGE_TAUX_CONTRINUTIONS_PRODUITS' /></xsl:when>
            <xsl:when test="$etat = 'MODVOTBDG'"><xsl:value-of select='$ELEMENT_PAGE_MODALITES_VOTE_BUDGET' /></xsl:when>
            <xsl:when test="$etat = 'DEPINV'"><xsl:value-of select='$ELEMENT_PAGE_DEPENSES_D_INVESTISSEMENT_ORDO' /></xsl:when>
            <xsl:when test="$etat = 'RECINV'"><xsl:value-of select='$ELEMENT_PAGE_RECETTES_D_INVESTISSEMENT_ORDO' /></xsl:when>
            <xsl:when test="$etat = 'DEPFONC'"><xsl:value-of select='$ELEMENT_PAGE_DEPENSES_DE_FONCTIONNEMENT_ORDO' /></xsl:when>
            <xsl:when test="$etat = 'RECFONC'"><xsl:value-of select='$ELEMENT_PAGE_RECETTES_DE_FONCTIONNEMENT_ORDO' /></xsl:when>
            <xsl:when test="$etat = 'OPEEQUIP'"><xsl:value-of select='$ELEMENT_PAGE_OPERATIONS_D_EQUIPEMENT' /></xsl:when>
            <xsl:when test="$etat = 'ARRESIGN'"><xsl:value-of select='$ELEMENT_PAGE_SIGNATURES' /></xsl:when>
            <xsl:when test="$etat = 'BALGENCPT'"><xsl:value-of select='$ELEMENT_PAGE_BAL_GENERALE' /></xsl:when>
            <xsl:when test="$etat = 'ETATBVI'"><xsl:value-of select='$ELEMENT_PAGE_BAL_VAL_INACTIVE' /></xsl:when>
            <xsl:when test="$etat = 'ANNOCCA'"><xsl:value-of select='$ELEMENT_PAGE_ANOMALIE_CCA' /></xsl:when>
            <xsl:when test="$etat = 'ETATEDDS'"><xsl:value-of select='$ELEMENT_PAGE_ETAT_EDDS' /></xsl:when>
            <xsl:when test="$etat = 'ETATLACTF'"><xsl:value-of select='$ELEMENT_PAGE_ETAT_LACTF' /></xsl:when>
            <xsl:when test="$etat = 'ETATFICBUDG'"><xsl:value-of select='$ELEMENT_PAGE_FIC_BUDG' /></xsl:when>
            <xsl:when test="$etat = 'ETATOPC'"><xsl:value-of select='$ELEMENT_PAGE_ETAT_OPC' /></xsl:when>
            <xsl:when test="$etat = 'ETATRAP'"><xsl:value-of select='$ELEMENT_PAGE_ETAT_RAP' /></xsl:when>
            <xsl:when test="$etat = 'ETATRAR'"><xsl:value-of select='$ELEMENT_PAGE_ETAT_RAR' /></xsl:when>
            <xsl:when test="$etat = 'ETATORMC'"><xsl:value-of select='$ELEMENT_PAGE_LIST_ORMC' /></xsl:when>
            <xsl:when test="$etat = 'ETATOPO'"><xsl:value-of select='$ELEMENT_PAGE_LIST_OPO' /></xsl:when>
            <xsl:when test="$etat = 'ETATORO'"><xsl:value-of select='$ELEMENT_PAGE_LIST_ORO' /></xsl:when>
            <xsl:when test="$etat = 'DEPEXP'"><xsl:value-of select='$ELEMENT_PAGE_DEPENSES_D_EXPLOITATION_ORDO' /></xsl:when>
            <xsl:when test="$etat = 'RECEXP'"><xsl:value-of select='$ELEMENT_PAGE_RECETTES_D_EXPLOITATION_ORDO' /></xsl:when>
            <xsl:when test="$etat = 'VUDEP'"><xsl:value-of select='$ELEMENT_PAGE_DEPENSES_VUE_NATURE_ORDO_FONCTION' /></xsl:when>
            <xsl:when test="$etat = 'VUREC'"><xsl:value-of select='$ELEMENT_PAGE_RECETTES_VUE_NATURE_ORDO_FONCTION' /></xsl:when>
            <xsl:when test="$etat = 'DEPINVFON'"><xsl:value-of select='$ELEMENT_PAGE_DEPENSES_D_INVESTISSEMENT_ORDO_FONCTION' /></xsl:when>
            <xsl:when test="$etat = 'RECINVFON'"><xsl:value-of select='$ELEMENT_PAGE_RECETTES_D_INVESTISSEMENT_ORDO_FONCTION' /></xsl:when>
            <xsl:when test="$etat = 'DEPFONCFON'"><xsl:value-of select='$ELEMENT_PAGE_DEPENSES_DE_FONCTIONNEMENT_ORDO_FONCTION' /></xsl:when>
            <xsl:when test="$etat = 'RECFONCFON'"><xsl:value-of select='$ELEMENT_PAGE_RECETTES_DE_FONCTIONNEMENT_ORDO_FONCTION' /></xsl:when>
            <xsl:when test="$etat = 'BALGE'"><xsl:value-of select='$ELEMENT_PAGE_BALANCE_GENERALE' /></xsl:when>
            <xsl:when test="$etat = 'RESEXEC'"><xsl:value-of select='$ELEMENT_PAGE_RESULTATS_EXECUTION_BP_BA' /></xsl:when>
            <xsl:otherwise><xsl:value-of select="$etat"/></xsl:otherwise>
        </xsl:choose>
    </xsl:function>
       
    <xsl:function name="n:replaceIndexInKey">
        <xsl:param name="key"/>
        <xsl:param name="indice"/>
        <xsl:variable name="before" select="substring-before($key,'(')"/>
        <xsl:variable name="after" select="substring-after($key,')')"/>
        <xsl:value-of select="concat($before,'(',$indice,')',$after)"></xsl:value-of>
    </xsl:function>

    <xsl:function name="n:makeEltKey">
        <xsl:param name="Param_2"/>
        <xsl:param name="Param_3"/>
        <xsl:param name="Param_4"/>
        <xsl:param name="Param_5"/>
        <xsl:param name="extraFilter"/>

        <xsl:choose>
            <xsl:when test="$Param_2 = 'BALGENCPT'">
				<xsl:value-of select="exo:computeFilter($CONFIGURATION_BALG, n:translateEtatToCode($Param_2), 1, (
                                                                            concat($CHAMP_BALG_EXERCICE, '=', $Param_4),
                                                                            concat($CHAMP_BALG_SIRET, '=', $Param_3),
                                                                            concat($CHAMP_BALG_SIRET_BA, '=', $Param_5), 
                                                                            $extraFilter))" />
			</xsl:when>
            <xsl:when test="$Param_2 = 'ETATBVI'">
				<xsl:value-of select="exo:computeFilter($CONFIGURATION_BVI, n:translateEtatToCode($Param_2), 1, (
                                                                            concat($CHAMP_BVI_EXERCICE, '=', $Param_4),
                                                                            concat($CHAMP_BVI_SIRET, '=', $Param_3),
                                                                            concat($CHAMP_BVI_SIRET_BA, '=', $Param_5), 
                                                                            $extraFilter))" />
			</xsl:when>
            <xsl:when test="$Param_2 = 'ANNOCCA'">
				<xsl:value-of select="exo:computeFilter($CONFIGURATION_CCA, n:translateEtatToCode($Param_2), 1, (
                                                                            concat($CHAMP_CCA_EXERCICE, '=', $Param_4),
                                                                            concat($CHAMP_CCA_SIRET, '=', $Param_3),
                                                                            concat($CHAMP_CCA_SIRET_BA, '=', $Param_5), 
                                                                            $extraFilter))" />
			</xsl:when>
            <xsl:when test="$Param_2 = 'ETATEDDS'">
				<xsl:value-of select="exo:computeFilter($CONFIGURATION_EDDS, n:translateEtatToCode($Param_2), 1, (
                                                                            concat($CHAMP_EDDS_EXERCICE, '=', $Param_4),
                                                                            concat($CHAMP_EDDS_SIRET, '=', $Param_3),
                                                                            concat($CHAMP_EDDS_SIRET_BA, '=', $Param_5), 
                                                                            $extraFilter))" />
			</xsl:when>
            <xsl:when test="$Param_2 = 'ETATLACTF'">
				<xsl:value-of select="exo:computeFilter($CONFIGURATION_LACTF, n:translateEtatToCode($Param_2), 1, (
                                                                            concat($CHAMP_LACTF_EXERCICE, '=', $Param_4),
                                                                            concat($CHAMP_LACTF_SIRET, '=', $Param_3),
                                                                            concat($CHAMP_LACTF_SIRET_BA, '=', $Param_5), 
                                                                            $extraFilter))" />
			</xsl:when>
            <xsl:when test="$Param_2 = 'ETATFICBUDG'">
				<xsl:value-of select="exo:computeFilter($CONFIGURATION_FIC_BUDG, n:translateEtatToCode($Param_2), 1, (
                                                                            concat($CHAMP_FIC_BUDG_EXERCICE, '=', $Param_4),
                                                                            concat($CHAMP_FIC_BUDG_SIRET, '=', $Param_3),
                                                                            concat($CHAMP_FIC_BUDG_SIRET_BA, '=', $Param_5), 
                                                                            $extraFilter))" />
			</xsl:when>
            <xsl:when test="$Param_2 = 'ETATOPC'">
				<xsl:value-of select="exo:computeFilter($CONFIGURATION_OPC, n:translateEtatToCode($Param_2), 1, (
                                                                            concat($CHAMP_OPC_EXERCICE, '=', $Param_4),
                                                                            concat($CHAMP_OPC_SIRET, '=', $Param_3),
                                                                            concat($CHAMP_OPC_SIRET_BA, '=', $Param_5), 
                                                                            $extraFilter))" />
			</xsl:when>
            <xsl:when test="$Param_2 = 'ETATRAP'">
				<xsl:value-of select="exo:computeFilter($CONFIGURATION_RAP, n:translateEtatToCode($Param_2), 1, (
                                                                            concat($CHAMP_RAP_EXERCICE, '=', $Param_4),
                                                                            concat($CHAMP_RAP_SIRET, '=', $Param_3),
                                                                            concat($CHAMP_RAP_SIRET_BA, '=', $Param_5), 
                                                                            $extraFilter))" />
			</xsl:when>
            <xsl:when test="$Param_2 = 'ETATRAR'">
				<xsl:value-of select="exo:computeFilter($CONFIGURATION_RAR, n:translateEtatToCode($Param_2), 1, (
                                                                            concat($CHAMP_RAR_EXERCICE, '=', $Param_4),
                                                                            concat($CHAMP_RAR_SIRET, '=', $Param_3),
                                                                            concat($CHAMP_RAR_SIRET_BA, '=', $Param_5), 
                                                                            $extraFilter))" />
			</xsl:when>
            <xsl:when test="$Param_2 = 'ETATORMC'">
				<xsl:value-of select="exo:computeFilter($CONFIGURATION_ORMC, n:translateEtatToCode($Param_2), 1, (
                                                                            concat($CHAMP_ORMC_EXERCICE, '=', $Param_4),
                                                                            concat($CHAMP_ORMC_SIRET, '=', $Param_3),
                                                                            concat($CHAMP_ORMC_SIRET_BA, '=', $Param_5), 
                                                                            $extraFilter))" />
			</xsl:when>
            <xsl:when test="$Param_2 = 'ETATOPO'">
				<xsl:value-of select="exo:computeFilter($CONFIGURATION_OPO, n:translateEtatToCode($Param_2), 1, (
                                                                            concat($CHAMP_OPO_EXERCICE, '=', $Param_4),
                                                                            concat($CHAMP_OPO_SIRET, '=', $Param_3),
                                                                            concat($CHAMP_OPO_SIRET_BA, '=', $Param_5), 
                                                                            $extraFilter))" />
			</xsl:when>
            <xsl:when test="$Param_2 = 'ETATORO'">
				<xsl:value-of select="exo:computeFilter($CONFIGURATION_ORO, n:translateEtatToCode($Param_2), 1, (
                                                                            concat($CHAMP_ORO_EXERCICE, '=', $Param_4),
                                                                            concat($CHAMP_ORO_SIRET, '=', $Param_3),
                                                                            concat($CHAMP_ORO_SIRET_BA, '=', $Param_5), 
                                                                            $extraFilter))" />
			</xsl:when>
            <xsl:otherwise>
				<xsl:value-of select="exo:computeFilter($CONFIGURATION_CFU, n:translateEtatToCode($Param_2), 1, (
                                                                            concat($CHAMP_CFU_EXERCICE, '=', $Param_4),
                                                                            concat($CHAMP_CFU_SIRET, '=', $Param_3),
                                                                            $extraFilter))" />
			</xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
    <xsl:function name="n:getRefEtat">
    	<xsl:param name = "etatCode"/>
    	<xsl:choose>
    		<xsl:when test="$etatCode = 'BALGENCPT'"><xsl:value-of select="'EtatBalanceGenerale'"/></xsl:when>
    		<xsl:when test="$etatCode = 'ANNOCCA'"><xsl:value-of select="'AnomaliesCCA'"/></xsl:when>
    		<xsl:when test="$etatCode = 'ETATBVI'"><xsl:value-of select="'EtatBalanceVI'"/></xsl:when>
    		<xsl:when test="$etatCode = 'ETATEDDS'"><xsl:value-of select="'EtatEDDS'"/></xsl:when>
    		<xsl:when test="$etatCode = 'ETATLACTF'"><xsl:value-of select="'EtatLACTF'"/></xsl:when>
    		<xsl:when test="$etatCode = 'ETATFICBUDG'"><xsl:value-of select="'EtatFichesBudgetaires'"/></xsl:when>
    		<xsl:when test="$etatCode = 'ETATOPC'"><xsl:value-of select="'EtatOPC'"/></xsl:when>
    		<xsl:when test="$etatCode = 'ETATRAP'"><xsl:value-of select="'EtatRAP'"/></xsl:when>
    		<xsl:when test="$etatCode = 'ETATRAR'"><xsl:value-of select="'EtatRAR'"/></xsl:when>
    		<xsl:when test="$etatCode = 'ETATORMC'"><xsl:value-of select="'EtatORMC'"/></xsl:when>
    		<xsl:when test="$etatCode = 'ETATOPO'"><xsl:value-of select="'EtatOPO'"/></xsl:when>
    		<xsl:when test="$etatCode = 'ETATORO'"><xsl:value-of select="'EtatORO'"/></xsl:when>
    		<xsl:otherwise><xsl:value-of select="'CFUREPORT'"/></xsl:otherwise>
    	</xsl:choose>
    </xsl:function>
    
    <xsl:function name="n:reportExists">
    	<xsl:param name="etat"/>
    	<xsl:param name="siret"/>
    	<xsl:param name="exercice"/>
    	<xsl:param name="siretBA"/>
			<xsl:variable name="isNewCfu" select="count($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:LigneSommairePlus[@RefEtat='EtatsCfu']) > 0"/>
        <xsl:choose>
        	<xsl:when test="$isNewCfu and ($etat != 'ETATORMC' and $etat != 'ETATOPO' and $etat != 'ETATORO' and $etat != 'ANNOCCA')">
        		<xsl:variable name="report" select="n:getRefEtat($etat)"/>
        		<xsl:choose>
        			<xsl:when test="$report = 'CFUREPORT'">
        				<xsl:variable name="xsl" select="concat($etat,'.xsl')"/>
		        		<xsl:value-of select="count($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:LigneSommairePlus[@RefEtat=$xsl][@Modele=concat($siret,'_',$exercice)]) > 0"/>
		        	</xsl:when>
		        	<xsl:otherwise>
		        		<xsl:value-of select="count($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:LigneSommairePlus[@RefEtat=$report][@Modele=concat($siret,'_',$exercice)]) > 0"/>
		        	</xsl:otherwise>
        		</xsl:choose>
        	</xsl:when>
        	<xsl:when test="$etat = 'ETATORMC' or $etat = 'ETATOPO' or $etat = 'ETATORO' or $etat = 'ANNOCCA'">
        		<xsl:value-of select='true()'/>
        	</xsl:when>
        	<xsl:otherwise>
       			<xsl:variable name="codeElt" select="n:translateEtatToCode($etat)"/>
        		<xsl:value-of select="n:summaryReportCheck($etat, $siret, $exercice, $codeElt, $siretBA)"/>
        	</xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="n:format-number">
        <xsl:param name="number"/>

        <xsl:choose>
            <xsl:when test="string-length($number) = 0 or string(number($number)) = 'NaN'"/>
            <xsl:otherwise>
                <xsl:value-of select="format-number($number, '## ##0,00', 'european')"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="n:trim" as="xs:string">
        <xsl:param name="arg"/>
        <xsl:sequence select="replace(replace($arg,'\s+$',''),'^\s+','')"/>
    </xsl:function>

    <xsl:function name="n:makeBalanceLinkKey">
        <xsl:param name="Exercice"/>
        <xsl:param name="Siret"/>
        <xsl:param name="siretBA"/>
        <xsl:param name="etat"/>
        <xsl:param name="numCompte"/>
        <xsl:param name="montant"/>
        <xsl:param name="codRD"/>

        <xsl:choose>
            <xsl:when test="$etat = 'FichesBudgetaires'">
                <xsl:value-of select="exo:computeFilter($CONFIGURATION_FIC_BUDG, $ELEMENT_PAGE_FIC_BUDG, 1, (
                         concat($CHAMP_FIC_BUDG_EXERCICE, '=', $Exercice),
                         concat($CHAMP_FIC_BUDG_SIRET, '=', $Siret),
                         concat($CHAMP_FIC_BUDG_SIRET_BA, '=', $siretBA),
                         concat($CHAMP_FIC_BUDG_NUM_COMPTE, '~=', $numCompte),
                         concat($CHAMP_FIC_BUDG_COD_RD, '=', $codRD)
                ))"/>
            </xsl:when>

            <xsl:when test="$etat = 'LivreAuxiliaire'">
                <xsl:value-of select="exo:computeFilter($CONFIGURATION_LACTF, $ELEMENT_PAGE_ETAT_LACTF, 1, (
                      concat($CHAMP_LACTF_EXERCICE, '=', $Exercice),
                      concat($CHAMP_LACTF_SIRET, '=', $Siret),
                      concat($CHAMP_LACTF_SIRET_BA, '=', $siretBA),
                      concat($CHAMP_LACTF_NUM_COMPTE, '~=', $numCompte)
                ))"/>
            </xsl:when>

            <xsl:when test="$etat = 'DeveloppementSoldes'">
                <xsl:value-of select="exo:computeFilter($CONFIGURATION_EDDS, $ELEMENT_PAGE_ETAT_EDDS, 1, (
                        concat($CHAMP_EDDS_EXERCICE, '=', $Exercice),
                        concat($CHAMP_EDDS_SIRET, '=', $Siret),
                        concat($CHAMP_EDDS_SIRET_BA, '=', $siretBA),
                        concat($CHAMP_EDDS_NUM_COMPTE, '~=', $numCompte)
                    ))"/>
            </xsl:when>

            <xsl:when test="$etat = 'ERAR'">
                <xsl:value-of select="exo:computeFilter($CONFIGURATION_RAR, $ELEMENT_PAGE_ETAT_RAP, 1, (
                        concat($CHAMP_RAR_EXERCICE, '=', $Exercice),
                        concat($CHAMP_RAR_SIRET, '=', $Siret),
                        concat($CHAMP_RAR_SIRET_BA, '=', $siretBA),
                        concat($CHAMP_RAR_NUM_COMPTE, '~=', $numCompte)
                    ))"/>
            </xsl:when>

            <xsl:when test="$etat = 'ERAP'">
                <xsl:value-of select="exo:computeFilter($CONFIGURATION_RAP, $ELEMENT_PAGE_ETAT_RAR, 1, (
                        concat($CHAMP_RAP_EXERCICE, '=', $Exercice),
                        concat($CHAMP_RAP_SIRET, '=', $Siret),
                        concat($CHAMP_RAP_SIRET_BA, '=', $siretBA),
                        concat($CHAMP_RAP_NUM_COMPTE, '~=', $numCompte)
                    ))"/>
            </xsl:when>

            <xsl:otherwise></xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
</xsl:stylesheet>