<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"/><xsl:import href="../../../../date.xsl"/><xsl:import href="../../../../table.xsl"/><xsl:import href="../../../../style.xsl"/><xsl:import href="../../../../lien.xsl"/><xsl:variable name="page-format" select="portrait"/><xsl:output encoding="UTF-8" method="xml" indent="yes"/><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"/><xsl:param name="nomenclaturePasEnrichie"/><xsl:variable name="nomenclature" select="document('libellePlanCompte.xml')/n:Nomenclature"/><xsl:variable name="data" select="document('libelleAffiche.xml')/data"/><xsl:variable name="isPrint" select="1"/><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"/><xsl:template match="/dcfu:CompteFinancierUnique"/><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
            <meta name="generator" content="ODM"/>
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css"/>
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css"/>
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:Wingdings;
  panose-1:5 0 0 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Calibri;
  panose-1:2 15 5 2 2 2 4 3 2 4;}
@font-face
  {font-family:Tahoma;
  panose-1:2 11 6 4 3 5 4 4 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoBodyText3, li.MsoBodyText3, div.MsoBodyText3
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:8.0pt;
  font-family:"Times New Roman",serif;}
p.MsoAcetate, li.MsoAcetate, div.MsoAcetate
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:8.0pt;
  font-family:"Tahoma",sans-serif;}
p.MsoListParagraph, li.MsoListParagraph, div.MsoListParagraph
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpFirst, li.MsoListParagraphCxSpFirst, div.MsoListParagraphCxSpFirst
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpMiddle, li.MsoListParagraphCxSpMiddle, div.MsoListParagraphCxSpMiddle
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpLast, li.MsoListParagraphCxSpLast, div.MsoListParagraphCxSpLast
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
span.En-tteCar
  {
  }
span.PieddepageCar
  {
  }
span.TextedebullesCar
  {
  
  font-family:"Tahoma",sans-serif;}
span.Corpsdetexte3Car
  {
  
  font-family:"Times New Roman",serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
 /* List Definitions */
 ol
  {margin-bottom:0in;}
ul
  {margin-bottom:0in;}
--&gt;
/**/
}</style></head>
         
         
         
      <body lang="EN-US"><xsl:variable name="Refer1">AVOTEBUDG</xsl:variable><xsl:variable name="Refer2" select="$docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:IdColl/@V"/><xsl:variable name="Refer3" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer1, '_', $Refer2, '_', $Refer3)"/></xsl:call-template><div id="header">
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &quot;Arial&quot;,&quot;sans-serif&quot;"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"/> - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"/> - <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"/>  - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"/></span></b></p>
               
            </div><div class="WordSection1">
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab1">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        <tr>
                           <td width="86.2%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">II – EXECUTION BUDGETAIRE</span></b></p>
                              
                           </td>
                           <td width="13.8%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">II</span></b></p>
                              
                           </td>
                        </tr>
                        <tr>
                           <td width="86.2%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">MODALITES DE VOTE DU BUDGET</span></b></p>
                              
                           </td>
                           <td width="13.8%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">A</span></b></p>
                              
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab1"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoHeader"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab2">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse">
                        <tr>
                           <td width="100%" valign="top" style="border:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
                              <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif">I – L'assemblée délibérante a voté le budget :</span></p>
                              <p class="MsoListParagraphCxSpFirst" style="margin-left:24.0pt;text-align:justify; text-indent:-.25in"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">-<span style="font:7.0pt &quot;Times New Roman&quot;">      </span></span><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">au niveau <xsl:value-of select="distinct-values($data/data:LibelleNatVoteI/data:valeur[@value = $docbudg//n:Budget/n:BlocBudget/n:NatVote/@V]/text())"/> (1) pour la section d’investissement ;</span></p>
                              <p class="MsoListParagraphCxSpLast" style="margin-left:24.0pt;text-align:justify; text-indent:-.25in"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">-<span style="font:7.0pt &quot;Times New Roman&quot;">      </span></span><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">au niveau <xsl:value-of select="distinct-values($data/data:LibelleNatVoteF/data:valeur[@value = $docbudg//n:Budget/n:BlocBudget/n:NatVote/@V]/text())"/> (1) pour la section de fonctionnement ;</span></p>
                              <p class="MsoNormal" style="margin-left:24.0pt;text-align:justify;text-indent: -.25in"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">-<span style="font:7.0pt &quot;Times New Roman&quot;">      </span></span><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($data/data:LibelleOpeEquip/data:valeur[@value = $docbudg//n:Budget/n:BlocBudget/n:OpeEquip/@V]/text())"/> (2) vote formel sur les chapitres « opérations d’équipement » ;</span></p>
                              <p class="MsoNormal" style="margin-left:24.0pt;text-align:justify;text-indent: -.25in"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">-<span style="font:7.0pt &quot;Times New Roman&quot;">      </span></span><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($data/data:LibelleVoteFormelChap/data:valeur[@value = $docbudg//n:Budget/n:BlocBudget/n:VoteFormelChap/@V]/text())"/> (2) vote formel sur chacun des chapitres.</span></p>
                              <p class="MsoBodyText3" align="left" style="text-align:left"><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif"> </span></p>
                              <p class="MsoBodyText3" align="left" style="text-align:left"><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">La liste des articles spécialisés sur lesquels l'ordonnateur ne peut procéder à des virements d'article à article est la suivante
                                    :</span></p>
                              <xsl:variable name="varOdmTmpTab3">
                                 <table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                                    <xsl:variable name="varOdm1">
                                       <xsl:for-each select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:ArtSpe/@V='true')]/n:Nature/@V)">
                                          <xsl:sort select="."/>
                                          <xsl:variable name="codeBoucle" select="."/><xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:Nature/@V=$codeBoucle) and (./n:ArtSpe/@V='true')]"/>
                                          <xsl:if test="$ligne">
                                             <tr>
                                                <td width="100%" valign="top" style="padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                                                   <p class="MsoBodyText3" align="left" style="text-align:left"><span style="font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($codeBoucle)"/></span></p>
                                                </td>
                                             </tr>
                                          </xsl:if>
                                       </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:variable name="varOdm2">
                                       <xsl:choose>
                                          <xsl:when test="count($varOdm1/*) = 0">
                                             <tr class=" #tech#">
                                                <td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding:0in 5.4pt 0in 5.4pt"/>
                                             </tr>
                                          </xsl:when>
                                          <xsl:otherwise>
                                             <xsl:sequence select="$varOdm1"/>
                                          </xsl:otherwise>
                                       </xsl:choose>
                                    </xsl:variable>
                                    <xsl:call-template name="table:processRowBorders">
                                       <xsl:with-param name="borderStyle" select="'solid 1.0pt'"/>
                                       <xsl:with-param name="rows" select="$varOdm2/xhtml:tr"/>
                                    </xsl:call-template>
                                 </table>
                              </xsl:variable>
                              <xsl:call-template name="table:outputTable">
                                 <xsl:with-param name="table" select="$varOdmTmpTab3"/>
                              </xsl:call-template>
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&quot;Arial&quot;,sans-serif"> </span></p>
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&quot;Arial&quot;,sans-serif"> </span></p>
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">II –</span><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">En l’absence de mention au paragraphe I ci-dessus, le budget est réputé voté par chapitre, sans vote formel sur chacun des
                                    chapitres, en fonctionnement, et en investissement sans vote formel pour les chapitres « opération d’équipement ».</span></p>
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">III – L’assemblée délibérante a autorisé le président à opérer des virements de crédits de paiement de chapitre à chapitre
                                    dans les limites suivantes (3) : <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='LimiteVirementCP')]/@V)"/>.</span></p>
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">IV – En l’absence de mention au paragraphe III ci-dessus, le président est réputé ne pas avoir reçu l’autorisation de l’assemblée
                                    délibérante de pratiquer des virements de crédits de paiement</span></p>
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">de chapitre à chapitre.</span></p>
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
                              <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif">V – Les provisions sont <xsl:value-of select="distinct-values($data/data:LibelleTypProv/data:valeur[@value = $docbudg//n:Budget/n:BlocBudget/n:TypProv/@V]/text())"/> <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:RefProv/@V)"/> (4).</span></p>
                              <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab2"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 6.0pt;font-family:&quot;Arial&quot;,sans-serif">(1) A compléter par « du chapitre » ou « de l’article ».</span></p>
               
               <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 6.0pt;font-family:&quot;Arial&quot;,sans-serif">(2) Indiquer « avec » ou « sans » vote formel.</span></p>
               
               <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 6.0pt;font-family:&quot;Arial&quot;,sans-serif">(3) </span><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">Au maximum dans la limite de 7.5 % des dépenses réelles de la section, à l’exclusion des crédits relatifs aux dépenses de
                     personnel.</span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(4) A compléter par un seul des deux choix suivants, selon les dispositions législatives et réglementaires applicables à la
                     collectivité :</span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">- semi budgétaire ;</span></p>
               
               <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 6.0pt;font-family:&quot;Arial&quot;,sans-serif">- budgétaire par délibération N°… du ...</span></p>
               
            </div></body></html>
   </xsl:template></xsl:stylesheet>