<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="dcfu:CompteFinancierUnique"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.Contenudetableau, li.Contenudetableau, div.Contenudetableau
  {
  margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
}size:297mm 210mm;
  }
div.WordSection2
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR"><div id="header">
         <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><td width="75%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p style="punctuation-wrap:simple">
                     <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@CodeBC)"/> – 
                     
                     
                     <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Libelle)"/>
                  </p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right;punctuation-wrap:simple">Exercice 
                     
                     
                     <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V)"/>
                  </p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt"> </span></p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><tr><td width="90%" valign="top" style="border:solid black 1.0pt; border-right:none;padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><xsl:variable name ="Refer73">DBILANSYNTH</xsl:variable><xsl:variable name ="Refer74" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Refer75" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer73, '_', $Refer74, '_', $Refer75)"/></xsl:call-template><b>I – INFORMATIONS GÉNÉRALES ET SYNTHÉTIQUES</b></p>
               </td><td width="10%" valign="top" style="border:solid black 1.0pt; padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><b>I</b></p>
               </td></tr><tr><td width="90%" valign="top" style="border-top:none;border-left: solid black 1.0pt;border-bottom:solid black 1.0pt;border-right:none; padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><b>Bilan synthétique (en milliers d'euros)</b></p>
               </td><td width="10%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><b>D</b></p>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size:11.0pt"> </span></p>
         <xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoTableGrid BORDURE" border="0" cellspacing="0" cellpadding="0"><tr><td width="50%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1">
                  <xsl:variable name="varOdmTmpTab4"><table width="100%" class="MsoTableGrid BORDURE" border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm1" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable[(./dc:Etat/@V='BI_S_A') and (./dc:ModeTraitement/@V!='NOTE_BAS_PAGE')]"/><thead>
                        <tr height="0" class="#tech# #fixWidths#"><td width="76%" style="border:none" rowspan="1" colspan="1"></td><td width="24%" style="border:none" rowspan="1" colspan="1"></td></tr>
                        <tr><xsl:variable name="varOdm2" select="$varOdm1"/><xsl:variable name="content277">
                              <p class="Contenudetableau"><span><b>ACTIF NET (1)</b></span></p>
                           </xsl:variable><xsl:variable name="className525">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className525" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">76%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content277" /></xsl:call-template><xsl:variable name="content278">
                              <p class="Contenudetableau"><b><span>Total</span></b></p>
                           </xsl:variable><xsl:variable name="className526">VBORDER</xsl:variable><xsl:variable name="className527">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className526, ' ', $className527)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">24%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content278" /></xsl:call-template></tr>
                     </thead><xsl:variable name="varOdm3" select="$varOdm1"/><xsl:variable name="varOdm4"><xsl:for-each select="$varOdm3"><xsl:sort select="./dc:NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content279"><xsl:value-of select="distinct-values($ligne/dc:Intitule1/@V)"/></xsl:variable><xsl:variable name="className528" select="$ligne/dc:Format/@V"/><xsl:variable name="className529">LIBELLE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className528, ' ', $className529)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">76%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content279" /></xsl:call-template><xsl:variable name="content280"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtNet/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className530" select="$ligne/dc:Format/@V"/><xsl:variable name="className531">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className530, ' ', $className531)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">24%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content280" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm5"><xsl:choose><xsl:when test="count($varOdm4/*) = 0"><tr class=" #tech#"><td height="1px" width="76%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm; "></td><td height="1px" width="24%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm; "></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm4"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm5/xhtml:tr"></xsl:with-param></xsl:call-template><tr><xsl:variable name="varOdm6" select="$varOdm1"/><td width="24%" colspan="2" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1">
                           <p class="MsoNormal" style="punctuation-wrap:simple"><xsl:if test="not($varOdm6/dc:NumOrdre/@V and $varOdm6/dc:Etat/@V='BI_S_A')">Cet état ne contient pas d'information.</xsl:if></p>
                        </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab4"></xsl:with-param></xsl:call-template>
               </td><td width="50%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1">
                  <xsl:variable name="varOdmTmpTab5"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm7" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable[(./dc:Etat/@V='BI_S_P')]"/><thead>
                        <tr height="0" class="#tech# #fixWidths#"><td width="1%" style="border:none" rowspan="1" colspan="1"></td><td width="75%" style="border:none" rowspan="1" colspan="1"></td><td width="24%" style="border:none" rowspan="1" colspan="1"></td></tr>
                        <tr><xsl:variable name="varOdm8" select="$varOdm7"/><xsl:variable name="content281">
                              <p class="Contenudetableau"><b><span>FONDS PROPRES ET PASSIF</span></b><span></span></p>
                           </xsl:variable><xsl:variable name="className532">VBORDER</xsl:variable><xsl:variable name="className533">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className532, ' ', $className533)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">76%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content281" /></xsl:call-template><xsl:variable name="content282">
                              <p class="Contenudetableau"><b><span>Total</span></b></p>
                           </xsl:variable><xsl:variable name="className534">VBORDER</xsl:variable><xsl:variable name="className535">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className534, ' ', $className535)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">24%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content282" /></xsl:call-template></tr>
                     </thead><xsl:variable name="varOdm9" select="$varOdm7"/><xsl:variable name="varOdm10"><xsl:for-each select="$varOdm9"><xsl:sort select="./dc:NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content283"><xsl:value-of select="distinct-values($ligne/dc:Intitule1/@V)"/></xsl:variable><xsl:variable name="className536" select="$ligne/dc:Format/@V"/><xsl:variable name="className537">LIBELLE</xsl:variable><xsl:variable name="className538">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className536, ' ', $className537, ' ', $className538)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">76%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content283" /></xsl:call-template><xsl:variable name="content284"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtNet/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className539" select="$ligne/dc:Format/@V"/><xsl:variable name="className540">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className539, ' ', $className540)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">24%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content284" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm11"><xsl:choose><xsl:when test="count($varOdm10/*) = 0"><tr class=" #tech#"><td height="1px" width="76%" colspan="2" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm; "></td><td height="1px" width="24%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm; "></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm10"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm11/xhtml:tr"></xsl:with-param></xsl:call-template><tr><xsl:variable name="varOdm12" select="$varOdm7"/><td width="1%" style="border:none;padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal"> </p>
                        </td><td width="76%" colspan="2" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1">
                           <p class="MsoNormal" style="punctuation-wrap:simple"><xsl:if test="not($varOdm12/dc:NumOrdre/@V and $varOdm12/dc:Etat/@V='BI_S_P')">Cet état ne contient pas d'information.</xsl:if></p>
                        </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab5"></xsl:with-param></xsl:call-template>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"> </p>
         <p class="MsoNormal"> </p>
      </div><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif"><br clear="all" style="page-break-before:auto" /></span><div class="WordSection2">
         <xsl:variable name="varOdmTmpTab6"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm13" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable[(./dc:ModeTraitement/@V='NOTE_BAS_PAGE') and (./dc:Etat/@V='BI_S_A')]"/><tr><td width="100%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="MsoNormal" style="line-height:115%;layout-grid-mode:char;punctuation-wrap: simple"><span style="font-size:6.0pt;line-height:115%"></span></p>
               </td></tr><xsl:variable name="varOdm14" select="$varOdm13"/><xsl:variable name="varOdm15"><xsl:for-each select="$varOdm14"><xsl:sort select="./dc:NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content285"><xsl:value-of select="distinct-values($ligne/dc:NoteBasTableau/@V)"/></xsl:variable><xsl:variable name="className541" select="$ligne/dc:Format/@V"/><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className541" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">100%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content285" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm16"><xsl:choose><xsl:when test="count($varOdm15/*) = 0"><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding:2.75pt 2.75pt 2.75pt 2.75pt"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm15"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm16/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab6"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt"> </span></p>
         <p class="MsoNormal"> </p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
        </script>
</html></xsl:template></xsl:stylesheet>