<?xml version="1.0" encoding="UTF-8"?>
<!--
    Copyright
    2010 axYus - http://www.axyus.com

    This file is part of ODM print-comp.

    ODM print-comp is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ODM print-comp is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with ODM print-comp; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:num="http://odm-budgetaire.org/utils/num"
                xmlns:fn="http://odm-budgetaire.org/utils/fn"
                extension-element-prefixes="num">
	<xsl:decimal-format name="decimalformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"/>
	<xsl:template name="num:number">
		<xsl:param name="num"/>
		<xsl:param name="format" select="'# ##0,00'"/> <!-- 2 chiffres après la virgule par défaut -->

		<!--
            On traite les formats arrondi et insécable en premier car ils peuvent être utilisés conjointement avec d'autres formats.
            On les retire ensuite de la chaîne format pour ne pas gêner le traitement des autres formats.

			** ATTENTION ** : Ne sont pas gérés les cas où un format n'est pas spécifié avec min, max, first ou zero.

        -->
		<xsl:variable name="asRounded" select="contains($format, ';rnd')"/>
		<xsl:variable name="asUnsecable" select="contains($format, ';unsec')"/>
		<xsl:variable name="asEmptyValue" select="contains($format, ';empty')"/>
		<xsl:variable name="attachedFormat" select="matches($format,'[#0 ,]+')"/>

                		<xsl:variable name="emptyValue">
                                                    <xsl:if test="$asEmptyValue">
				<xsl:value-of select="substring-before(substring-after(substring-after($format, ';empty'), '['), ']')"/>
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="cleanedFormat">
			<xsl:if test="$asRounded">
				<xsl:choose>
					<xsl:when test="$attachedFormat">
						<xsl:value-of select="concat(substring-before($format, ';rnd'), substring-after($format, ';rnd'))"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat(substring-before($format, ';rnd'), '# ##0,00', substring-after($format, ';rnd'))"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="$asUnsecable">
				<xsl:choose>
					<!-- On ne rajoute pas deux fois le format par défaut s'il a déjà été ajouté avec le rnd -->
					<xsl:when test="$attachedFormat or $asRounded">
						<xsl:value-of select="concat(substring-before($format, ';unsec'), substring-after($format, ';unsec'))"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat(substring-before($format, ';unsec'), '# ##0,00', substring-after($format, ';unsec'))"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="$asEmptyValue">
				<xsl:choose>
					<!-- On ne rajoute pas deux fois le format par défaut s'il a déjà été ajouté avec le rnd -->
					<xsl:when test="$attachedFormat or $asRounded or $asUnsecable">
						<xsl:value-of select="concat(normalize-space(substring-before($format, ';empty')), normalize-space(substring-after(substring-after($format, ';empty'), ']')))"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat(normalize-space(substring-before($format, ';empty')), '# ##0,00', normalize-space(substring-after(substring-after($format, ';empty'), ']')))"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="not($asUnsecable) and not($asRounded) and not($asEmptyValue)">
				<xsl:value-of select="$format"/>
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="pattern1" select="if (matches($cleanedFormat, ';zero$')) then substring-before($cleanedFormat, ';zero') else $cleanedFormat"/>
		<xsl:variable name="pattern2" select="if (matches($pattern1, '^min;')) then substring-after($pattern1, 'min;') else $pattern1"/>
		<xsl:variable name="pattern3" select="if (matches($pattern2, '^max;')) then substring-after($pattern2, 'max;') else $pattern2"/>
		<xsl:variable name="pattern" select="if (matches($pattern3, '^first;')) then substring-after($pattern3, 'first;') else $pattern3"/>

		<xsl:variable name="negativesAsZero" select="matches($format, ';zero$')"/>
		<xsl:variable name="asMax" select="matches($format, '^max;')"/>
		<xsl:variable name="asMin" select="matches($format, '^min;')"/>
		<xsl:variable name="asFirst" select="matches($format, '^first;')"/>

		<!-- Suppression des décimales -->
		<xsl:variable name="finalPattern">
			<xsl:choose>
				<xsl:when test="$asRounded">
					<xsl:value-of select="substring-before($pattern, ',')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$pattern"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="result">
            <xsl:choose>
                <xsl:when test="count($num)=0 and string($num) = 'NaN' and $asEmptyValue">
                    <xsl:value-of select="$emptyValue"/>
                </xsl:when>
                <xsl:when test="count($num) &lt; 2 and ($num = '' or string-length($num) = 0) and $asEmptyValue">
                    <xsl:value-of select="$emptyValue"/>
                </xsl:when>
                <xsl:when test="count($num)=0">
                    <xsl:value-of select="format-number(0,$finalPattern,'decimalformat')"/>
                </xsl:when>
                <xsl:when test="$negativesAsZero and (if (count($num) &gt; 1) then sum($num) &lt; 0 else $num &lt; 0)">
                    <xsl:value-of select="format-number(0,$finalPattern,'decimalformat')"/>
                </xsl:when>
                <xsl:when test="count($num) &gt; 1">
                    <xsl:choose>
                        <xsl:when test="$asMax">
                            <xsl:value-of select="format-number(fn:roundIfNeeded(max($num), $asRounded),$finalPattern,'decimalformat')"/>
                        </xsl:when>
                        <xsl:when test="$asMin">
                            <xsl:value-of select="format-number(fn:roundIfNeeded(min($num), $asRounded),$finalPattern,'decimalformat')"/>
                        </xsl:when>
                        <xsl:when test="$asFirst">
                            <xsl:value-of select="format-number(fn:roundIfNeeded($num[1], $asRounded),$finalPattern,'decimalformat')"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="format-number(fn:roundIfNeeded(sum($num), $asRounded),$finalPattern,'decimalformat')"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="string($num) = 'NaN'">
                    <xsl:value-of select="format-number(0,$finalPattern,'decimalformat')"/>
                </xsl:when>
                <xsl:when test="$num = 0">
                    <xsl:value-of select="format-number(0,$finalPattern,'decimalformat')"/>
                </xsl:when>
                <xsl:when test="$num = ''">
                    <xsl:value-of select="format-number(0,$finalPattern,'decimalformat')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="format-number(fn:roundIfNeeded($num, $asRounded),$finalPattern,'decimalformat')"/>
                </xsl:otherwise>
            </xsl:choose>
		</xsl:variable>

		<!--
            On applique l'insécable ici.

            La première solution consistait à insérer des espaces insécables (nbsp) entre les groupes de chiffres.
            Cette solution s'est révélée approximative puisque sur un grand nombre de colonnes affectées lesdits espaces
            étaient quand même rompu.
        -->
        <xsl:choose>
            <xsl:when test="$asUnsecable">
				<span style="display: inline-block; text-align: right; white-space: nowrap;">
					<xsl:for-each select="tokenize($result, ' ')">
						<xsl:value-of select="."/>
						<xsl:if test="position() ne last()">&#160;</xsl:if>
					</xsl:for-each>
				</span>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$result"/>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <!-- Applique un arrondi si nécessaire. -->
    <xsl:function name="fn:roundIfNeeded">
        <xsl:param name="number"/>
        <xsl:param name="round"/>
        <xsl:value-of select="if ($round) then round($number) else $number"/>
    </xsl:function>

</xsl:stylesheet>
