<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/BalanceGenerale"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="BalanceGenerale"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.Contenudetableau, li.Contenudetableau, div.Contenudetableau
  {
  margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR"><div id="header">
         <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><td width="75%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p style="margin-bottom:0cm;margin-bottom:.0001pt;line-height: normal;punctuation-wrap:simple"><span style="font-size:10.0pt;font-family: &#34;Arial&#34;,sans-serif">
                        <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@Codique)"/> – 
                        
                        
                        <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@LibellePoste)"/></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:right;line-height:normal;punctuation-wrap:simple"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">Date édition : 
                        
                        
                        <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateEdition)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif"> </span></p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Edition/@TypeEdition = 'P'"><xsl:variable name="varOdm1" select="$docbudg/Budget/LigneBalance"/><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1">
                  <p class="MsoNormal" align="right" style="margin-left:-366.5pt;text-align:right; punctuation-wrap:simple"><xsl:variable name ="Refer79">BALGENCPT</xsl:variable><xsl:variable name ="Refer80" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Refer81" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer79, '_', $Refer80, '_', $Refer81)"/></xsl:call-template>Édition provisoire
                     
                     
                  </p>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" colspan="2" valign="top" rowspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Edition/@TypeEdition = 'D'"><xsl:variable name="varOdm2" select="$docbudg/Budget/LigneBalance"/><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1">
                  <p class="MsoNormal" align="right" style="margin-left:-366.5pt;text-align:right; punctuation-wrap:simple">Édition définitive</p>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" colspan="2" valign="top" rowspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center;punctuation-wrap: simple"><b><span style="font-size:12.0pt">BALANCE RÉGLEMENTAIRE DES COMPTES DU GRAND LIVRE</span></b></p>
               </td></tr><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p align="center" style="text-align:center;punctuation-wrap: simple">arrêtée à la date du <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateArrete)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></p></td></tr><tr><td width="49%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="51%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td></tr><tr><td width="49%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="51%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td></tr><tr><td width="49%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p style="punctuation-wrap:simple"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@CodeBC)"/> – <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@Libelle)"/></p></td><td width="51%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right;punctuation-wrap:simple"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Exercice/@V)"/></p></td></tr><xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BA' or $docbudg/BalanceGenerale/EnteteComptable/Infos/Collectivite/@TypeBC = 'BR'"><xsl:variable name="varOdm3" select="$docbudg/Budget/LigneBalance"/><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p style="punctuation-wrap:simple">BA de <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetRattachement/@Libelle)"/></p></td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="49%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td><td height="1px" width="51%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><tr><td width="100%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoNormalTable BORDURE" border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm4" select="$docbudg/Budget/LigneBalance[(./NumOrdre/@V)]"/><thead>
               <tr><xsl:variable name="varOdm5" select="$varOdm4"/><xsl:variable name="content315">
                     <p class="Contenudetableau"><span><b>Numéro de compte</b></span></p>
                     <p class="Contenudetableau"><span></span></p>
                  </xsl:variable><xsl:variable name="className600">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className600" /><xsl:with-param name="rowspan">2</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">15%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content315" /></xsl:call-template><xsl:variable name="content316">
                     <p class="Contenudetableau"><b><span>Libellé du compte</span></b></p>
                  </xsl:variable><xsl:variable name="className601">VBORDER</xsl:variable><xsl:variable name="className602">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className601, ' ', $className602)" /><xsl:with-param name="rowspan">2</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">15%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content316" /></xsl:call-template><xsl:variable name="content317">
                     <p class="Contenudetableau"><b><span>Balance d’entrée</span></b></p>
                  </xsl:variable><xsl:variable name="className603">VBORDER</xsl:variable><xsl:variable name="className604">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className603, ' ', $className604)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content317" /></xsl:call-template><xsl:variable name="content318">
                     <p class="Contenudetableau"><b><span>Opérations non budgétaires</span></b></p>
                  </xsl:variable><xsl:variable name="className605">VBORDER</xsl:variable><xsl:variable name="className606">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className605, ' ', $className606)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content318" /></xsl:call-template><xsl:variable name="content319">
                     <p class="Contenudetableau"><b><span>Opérations budgétaires</span></b></p>
                  </xsl:variable><xsl:variable name="className607">VBORDER</xsl:variable><xsl:variable name="className608">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className607, ' ', $className608)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content319" /></xsl:call-template><xsl:variable name="content320">
                     <p class="Contenudetableau"><b><span>Total</span></b></p>
                  </xsl:variable><xsl:variable name="className609">VBORDER</xsl:variable><xsl:variable name="className610">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className609, ' ', $className610)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content320" /></xsl:call-template><xsl:variable name="content321">
                     <p class="Contenudetableau"><b><span>Soldes</span></b></p>
                  </xsl:variable><xsl:variable name="className611">VBORDER</xsl:variable><xsl:variable name="className612">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className611, ' ', $className612)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content321" /></xsl:call-template></tr>
               <tr><xsl:variable name="varOdm6" select="$varOdm4"/><xsl:variable name="content322">
                     <p class="Contenudetableau"><b><span>Débit</span></b></p>
                  </xsl:variable><xsl:variable name="className613">VBORDER</xsl:variable><xsl:variable name="className614">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className613, ' ', $className614)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content322" /></xsl:call-template><xsl:variable name="content323">
                     <p class="Contenudetableau"><b><span>Crédit</span></b></p>
                  </xsl:variable><xsl:variable name="className615">VBORDER</xsl:variable><xsl:variable name="className616">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className615, ' ', $className616)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content323" /></xsl:call-template><xsl:variable name="content324">
                     <p class="Contenudetableau"><b><span>Débit</span></b></p>
                  </xsl:variable><xsl:variable name="className617">VBORDER</xsl:variable><xsl:variable name="className618">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className617, ' ', $className618)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content324" /></xsl:call-template><xsl:variable name="content325">
                     <p class="Contenudetableau"><b><span>Crédit</span></b></p>
                  </xsl:variable><xsl:variable name="className619">VBORDER</xsl:variable><xsl:variable name="className620">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className619, ' ', $className620)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content325" /></xsl:call-template><xsl:variable name="content326">
                     <p class="Contenudetableau"><b><span>Débit</span></b></p>
                  </xsl:variable><xsl:variable name="className621">VBORDER</xsl:variable><xsl:variable name="className622">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className621, ' ', $className622)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content326" /></xsl:call-template><xsl:variable name="content327">
                     <p class="Contenudetableau"><b><span>Crédit</span></b></p>
                  </xsl:variable><xsl:variable name="className623">VBORDER</xsl:variable><xsl:variable name="className624">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className623, ' ', $className624)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content327" /></xsl:call-template><xsl:variable name="content328">
                     <p class="Contenudetableau"><b><span>Débit</span></b></p>
                  </xsl:variable><xsl:variable name="className625">VBORDER</xsl:variable><xsl:variable name="className626">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className625, ' ', $className626)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content328" /></xsl:call-template><xsl:variable name="content329">
                     <p class="Contenudetableau"><b><span>Crédit</span></b></p>
                  </xsl:variable><xsl:variable name="className627">VBORDER</xsl:variable><xsl:variable name="className628">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className627, ' ', $className628)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content329" /></xsl:call-template><xsl:variable name="content330">
                     <p class="Contenudetableau"><b><span>Débit</span></b></p>
                  </xsl:variable><xsl:variable name="className629">VBORDER</xsl:variable><xsl:variable name="className630">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className629, ' ', $className630)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content330" /></xsl:call-template><xsl:variable name="content331">
                     <p class="Contenudetableau"><b><span>Crédit</span></b></p>
                  </xsl:variable><xsl:variable name="className631">VBORDER</xsl:variable><xsl:variable name="className632">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className631, ' ', $className632)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content331" /></xsl:call-template></tr>
            </thead><xsl:variable name="varOdm7" select="$varOdm4"/><xsl:variable name="varOdm8"><xsl:for-each select="$varOdm7"><xsl:sort select="./NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content332"><xsl:value-of select="distinct-values($ligne/NumCompte/@V)"/></xsl:variable><xsl:variable name="className633" select="$ligne/Format/@V"/><xsl:variable name="className634">LIBELLE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className633, ' ', $className634)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">15%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content332" /></xsl:call-template><xsl:variable name="content333"><xsl:value-of select="distinct-values($ligne/LibelleRegl/@V)"/><xsl:value-of select="distinct-values($ligne/LibelleReglCompl/@V)"/></xsl:variable><xsl:variable name="className635" select="$ligne/Format/@V"/><xsl:variable name="className636">LIBELLE</xsl:variable><xsl:variable name="className637">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className635, ' ', $className636, ' ', $className637)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">15%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content333" /></xsl:call-template><xsl:variable name="content334"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtBalEntreeDeb/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className638" select="$ligne/Format/@V"/><xsl:variable name="className639">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className638, ' ', $className639)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content334" /></xsl:call-template><xsl:variable name="content335"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtBalEntreeCre/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className640" select="$ligne/Format/@V"/><xsl:variable name="className641">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className640, ' ', $className641)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content335" /></xsl:call-template><xsl:variable name="content336"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtOpeNonBudDeb/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className642" select="$ligne/Format/@V"/><xsl:variable name="className643">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className642, ' ', $className643)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content336" /></xsl:call-template><xsl:variable name="content337"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtOpeNonBudCre/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className644" select="$ligne/Format/@V"/><xsl:variable name="className645">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className644, ' ', $className645)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content337" /></xsl:call-template><xsl:variable name="content338"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtOpeBudDeb/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className646" select="$ligne/Format/@V"/><xsl:variable name="className647">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className646, ' ', $className647)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content338" /></xsl:call-template><xsl:variable name="content339"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtOpeBudCre/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className648" select="$ligne/Format/@V"/><xsl:variable name="className649">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className648, ' ', $className649)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content339" /></xsl:call-template><xsl:variable name="content340"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtTotDeb/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className650" select="$ligne/Format/@V"/><xsl:variable name="className651">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className650, ' ', $className651)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content340" /></xsl:call-template><xsl:variable name="content341"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtTotCre/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className652" select="$ligne/Format/@V"/><xsl:variable name="className653">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className652, ' ', $className653)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content341" /></xsl:call-template><xsl:variable name="content342"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtSoldeDeb/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className654" select="$ligne/Format/@V"/><xsl:variable name="className655">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className654, ' ', $className655)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content342" /></xsl:call-template><xsl:variable name="content343"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtSoldeCre/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className656" select="$ligne/Format/@V"/><xsl:variable name="className657">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className656, ' ', $className657)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content343" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm9"><xsl:choose><xsl:when test="count($varOdm8/*) = 0"><tr class=" #tech#"><td height="1px" width="7%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm8"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm9/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template>
         <xsl:variable name="varOdmTmpTab4"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><xsl:variable name="varOdm10" select="$docbudg/Budget/LigneBalance"/><td width="100%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                  <p class="MsoNormal" style="punctuation-wrap:simple"><xsl:if test="not($varOdm10/NumOrdre/@V)">Cet état ne contient pas d'information.</xsl:if></p>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab4"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size:4.0pt"> </span></p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
        </script>
</html></xsl:template></xsl:stylesheet>