<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:data="http://odm-budgetaire.org/data" xmlns:date="http://exslt.org/dates-and-times" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data">
   <xsl:import href="../../number.xsl"></xsl:import>
   <xsl:import href="../../date.xsl"></xsl:import>
   <xsl:import href="../../table.xsl"></xsl:import>
   <xsl:import href="../../style.xsl"></xsl:import>
   <xsl:import href="../../lien.xsl"></xsl:import>
   <xsl:import href="../../commons/constants.xsl"></xsl:import>
   <xsl:import href="../../commons/fonctions.xsl"></xsl:import>
   <xsl:import href="../../commons/templates.xsl"></xsl:import>
   <xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param>
   <xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param>
   <xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable>
   <xsl:param name="nomenclaturePasEnrichie"></xsl:param>
   <xsl:variable name="nomenclature" select="document('libellePlanCompte.xml')/n:Nomenclature"></xsl:variable>
   <xsl:variable name="data" select="document('libelleAffiche.xml')/data"></xsl:variable>
   <xsl:variable name="isPrint" select="1"></xsl:variable>
   <xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="/dcfu:CompteFinancierUnique"></xsl:template><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         
         
         <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
            
            
            
            
            
            <meta name="generator" content="ODM" />
            
            
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
            
            
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
            
            
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Tahoma;
  panose-1:2 11 6 4 3 5 4 4 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0cm;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
span.En-tteCar
  {
  
  font-family:"Times New Roman",serif;}
p.BodyText21, li.BodyText21, div.BodyText21
  {
  margin:0cm;
  font-size:9.0pt;
  font-family:"Times New Roman",serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style>
            </head>
         
         
         
         <body id="ETAT_RSTREALREC" lang="EN-US" style="word-wrap:break-word">
            
            
            <div id="header">
               
               
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &#34;Arial&#34;,&#34;sans-serif&#34;">
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"></xsl:value-of>  - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"></xsl:value-of></span></b></p>
               
               </div>
            
            
            
            
            <div class="WordSection1">
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab1">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        
                        <tr>
                           
                           
                           <td width="89.1%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">I – INFORMATIONS GENERALES</span></b></p>
                              
                              </td>
                           
                           
                           <td width="10.9%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">I</span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="89.1%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">DETAIL DES RESTES A REALISER – RAR RECETTES</span></b></p>
                              
                              </td>
                           
                           
                           <td width="10.9%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">C2</span></b></p>
                              
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal" style="margin-top:0cm;margin-right:46.5pt;margin-bottom: 0cm;margin-left:1.0cm;margin-bottom:.0001pt"><span lang="FR" style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal" style="margin-top:0cm;margin-right:46.5pt;margin-bottom: 0cm;margin-left:1.0cm;margin-bottom:.0001pt"><b><span lang="FR" style="font-family: &#34;Arial&#34;,sans-serif">DETAIL DES RESTES A REALISER N EN RECETTES (1)</span></b></p>
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab2">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        <xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0)                         and (./n:CodRD/@V='R')]"></xsl:variable>
                        
                        
                        <thead>
                           
                           
                           
                           <tr height="0" class="#tech# #fixWidths#">
                              
                              
                              <td width="12.4%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="49.9%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="4.3%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="33.4%" style="border:none" rowspan="1" colspan="1"></td>
                              </tr>
                           
                           
                           
                           <tr style="page-break-inside:avoid">
                              
                              
                              <td width="12.4%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Chap. / Art. (2)</span></b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"></span></p>
                                 
                                 </td>
                              
                              
                              <td width="49.9%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Libellé</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="37.7%" colspan="2" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Titres restant à émettre</span></b></p>
                                 
                                 </td>
                              </tr>
                           
                           </thead>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           
                           <td width="62.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">SECTION D’INVESTISSEMENT – TOTAL</span></b></p>
                              
                              </td>
                           
                           
                           <td width="4.3%" valign="top" style="border:none;border-bottom:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="BodyText21"><b><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(III)</span></b></p>
                              
                              </td>
                           
                           
                           <td width="33.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="BodyText21" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINV')]/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm2" select="$varOdm1[(n:ChapitreFonction/@V='900') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">900</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '900' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm2/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm3">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='900' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm4">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm3/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm3"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm4/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm5" select="$varOdm1[(n:ChapitreFonction/@V='9005') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">900-5</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '9005' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm5/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm6">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='9005' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border:none; border-right:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm7">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm6/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm6"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm7/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm8" select="$varOdm1[(n:ChapitreFonction/@V='901') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border:solid black 1.0pt; border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">901</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '901' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm8/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm9">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='901' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border:none; border-right:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm10">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm9/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style=" border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style=" border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm9"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm10/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm11" select="$varOdm1[(n:ChapitreFonction/@V='902') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border:solid black 1.0pt; border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">902</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '902' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm11/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm12">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='902' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border:none; border-right:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm13">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm12/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style=" border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style=" border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm12"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm13/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm14" select="$varOdm1[(n:ChapitreFonction/@V='903') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border:solid black 1.0pt; border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">903</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '903' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm14/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm15">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='903' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border:none; border-right:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm16">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm15/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style=" border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style=" border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm15"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm16/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm17" select="$varOdm1[(n:ChapitreFonction/@V='904') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border:solid black 1.0pt; border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">904</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '904' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (hors RSA)</span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm17/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm18">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='904' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border:none; border-right:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm19">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm18/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style=" border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style=" border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm18"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm19/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm20" select="$varOdm1[(n:ChapitreFonction/@V='9044') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border:solid black 1.0pt; border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">904-4</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '9044' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm20/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm21">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='9044' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border:none; border-right:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm22">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm21/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style=" border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style=" border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm21"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm22/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm23" select="$varOdm1[(n:ChapitreFonction/@V='905') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border:solid black 1.0pt; border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">905</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '905' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm23/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm24">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='905' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border:none; border-right:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm25">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm24/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style=" border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style=" border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm24"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm25/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm26" select="$varOdm1[(n:ChapitreFonction/@V='906') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border:solid black 1.0pt; border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">906</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '906' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm26/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm27">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='906' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border:none; border-right:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm28">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm27/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style=" border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style=" border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm27"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm28/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm29" select="$varOdm1[(n:ChapitreFonction/@V='907') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border:solid black 1.0pt; border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">907</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '907' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm29/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm30">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='907' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border:none; border-right:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm31">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm30/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style=" border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style=" border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm30"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm31/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm32" select="$varOdm1[(n:ChapitreFonction/@V='908') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border:solid black 1.0pt; border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">908</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '908' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm32/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm33">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='908' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border:none; border-right:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm34">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm33/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style=" border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style=" border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-right:solid black 1.0pt"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm33"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm34/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm35" select="$varOdm1[(n:ChapitreFonction/@V='921') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border:solid black 1.0pt; border-left:double black 2.25pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">921</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '921' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm35/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm36" select="$varOdm1[(n:ChapitreFonction/@V='922') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">922</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '922' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm36/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm37" select="$varOdm1[(n:ChapitreFonction/@V='923') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">923</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '923' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm37/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm38" select="$varOdm1[(n:ChapitreFonction/@V='954') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">954</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '954' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm38/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           
                           <td width="62.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">SECTION DE FONCTIONNEMENT – TOTAL</span></b></p>
                              
                              </td>
                           
                           
                           <td width="4.3%" valign="top" style="border:none;border-bottom:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="BodyText21"><b><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(IV)</span></b></p>
                              
                              </td>
                           
                           
                           <td width="33.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="BodyText21" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm39" select="$varOdm1[(n:ChapitreFonction/@V='930') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">930</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '930' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm39/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm40">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='930' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm41">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm40/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm40"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm41/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm42" select="$varOdm1[(n:ChapitreFonction/@V='9305') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">930-5</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '9305' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm42/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm43">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='9305' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm44">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm43/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm43"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm44/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm45" select="$varOdm1[(n:ChapitreFonction/@V='931') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">931</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '931' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm45/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm46">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='931' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm47">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm46/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm46"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm47/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm48" select="$varOdm1[(n:ChapitreFonction/@V='932') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">932</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '932' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm48/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm49">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='932' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm50">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm49/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm49"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm50/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm51" select="$varOdm1[(n:ChapitreFonction/@V='933') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">933</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '933' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm51/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm52">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='933' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm53">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm52/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm52"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm53/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm54" select="$varOdm1[(n:ChapitreFonction/@V='934') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">934</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '934' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (hors APA et RSA/Régularisation de RMI)</span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm54/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm55">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='934' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm56">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm55/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm55"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm56/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm57" select="$varOdm1[(n:ChapitreFonction/@V='9343') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">934-3</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '9343' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm57/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm58">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='9343' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm59">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm58/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm58"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm59/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm60" select="$varOdm1[(n:ChapitreFonction/@V='9344') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">934-4</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '9344' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm60/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm61">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='9344' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm62">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm61/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm61"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm62/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm63" select="$varOdm1[(n:ChapitreFonction/@V='935') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">935</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '935' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm63/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm64">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='935' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm65">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm64/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm64"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm65/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm66" select="$varOdm1[(n:ChapitreFonction/@V='936') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">936</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '936' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm66/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm67">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='936' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm68">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm67/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm67"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm68/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm69" select="$varOdm1[(n:ChapitreFonction/@V='937') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">937</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '937' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm69/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm70">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='937' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm71">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm70/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm70"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm71/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm72" select="$varOdm1[(n:ChapitreFonction/@V='938') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">938</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '938' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm72/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm73">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Fonction/n:Compte[@Type='C' and @Code='938' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:OpBudg/@V='0')                               and (./n:MtRAR3112/@V!=0) and (./n:CodRD/@V='R') and (./n:Fonction/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm74">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm73/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="12.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="49.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="37.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm73"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm74/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm75" select="$varOdm1[(n:ChapitreFonction/@V='940') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">940</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '940' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm75/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm76" select="$varOdm1[(n:ChapitreFonction/@V='941') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">941</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '941' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm76/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm77" select="$varOdm1[(n:ChapitreFonction/@V='942') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">942</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '942' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm77/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm78" select="$varOdm1[(n:ChapitreFonction/@V='943') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">943</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '943' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm78/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm79" select="$varOdm1[(n:ChapitreFonction/@V='944') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="12.4%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">944</span></b></p>
                              
                              </td>
                           
                           
                           <td width="49.9%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '944' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="37.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm79/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoHeader" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal" style="margin-right:9.65pt;text-align:justify"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(1) Il s’agit des restes à réaliser établis conformément à la comptabilité d’engagement
                     annuelle. Ces restes à réaliser seront
                     repris au BP ou au BS N+1</span><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">.</span></p>
               
               
               
               <p class="MsoNormal" style="margin-right:9.65pt;text-align:justify"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(2) Suivant le niveau de vote retenu par l’assemblée.</span></p>
               
               </div>
            
            
            
            <div id="footer">
               
               <p xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" class="MsoNormal"><span style="font-size:8.0pt;line-height:115%">
                     
                     <xsl:if test="$HTML_OUTPUT_FORMAT">
                        
                        <xsl:variable name="link1" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"></xsl:variable>
                        
                        <xsl:variable name="link2" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"></xsl:variable>
                        
                        <xsl:variable name="link3" select="'images/return.png'"></xsl:variable>
                        
                        <xsl:variable name="link4" select="'Accueil'"></xsl:variable>
                        
                        <xsl:variable name="link5" select="$link1"></xsl:variable>
                        
                        <xsl:variable name="link6" select="$link2"></xsl:variable>
                        
                        <xsl:call-template name="com:lienOutputImage">
                           
                           <xsl:with-param name="Param_0" select="'images/return.png'"></xsl:with-param>
                           
                           <xsl:with-param name="Param_1" select="$link3"></xsl:with-param>
                           
                           <xsl:with-param name="Param_2" select="$link4"></xsl:with-param>
                           
                           <xsl:with-param name="Param_3" select="$link5"></xsl:with-param>
                           
                           <xsl:with-param name="Param_4" select="$link6"></xsl:with-param>
                           </xsl:call-template>
                        </xsl:if></span></p>
               </div>
            </body>
         
         </html></xsl:template></xsl:stylesheet>