<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:style="http://odm-budgetaire.org/utils/style"
                extension-element-prefixes="style">

<xsl:template name="style:styler-valeur">
   <xsl:param name="style-class" />
   <xsl:param name="valeur" />

   <xsl:element name="p" namespace="">
	  <xsl:attribute name="class"><xsl:value-of select='$style-class' /></xsl:attribute>
	  <xsl:sequence select="$valeur" />
   </xsl:element>
</xsl:template>

<xsl:template name="style:styler-cellule">
   <xsl:param name="style-class" />
   <xsl:param name="rowspan" />
   <xsl:param name="colspan" />
   <xsl:param name="width" />
   <xsl:param name="height" />
   <xsl:param name="content" />

   <xsl:element name="td" namespace="">
	  <xsl:attribute name="class" select='$style-class'/>
	  <xsl:attribute name="rowspan" select='$rowspan'/>
	  <xsl:attribute name="colspan" select='$colspan'/>
	  <xsl:attribute name="width" select='$width'/>
	  <xsl:attribute name="height" select='$height'/>
	  <xsl:sequence select="$content" />
   </xsl:element>
</xsl:template>

</xsl:stylesheet>