<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:data="http://odm-budgetaire.org/data" xmlns:date="http://exslt.org/dates-and-times" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data">
   <xsl:import href="../../number.xsl"></xsl:import>
   <xsl:import href="../../date.xsl"></xsl:import>
   <xsl:import href="../../table.xsl"></xsl:import>
   <xsl:import href="../../style.xsl"></xsl:import>
   <xsl:import href="../../lien.xsl"></xsl:import>
   <xsl:import href="../../commons/constants.xsl"></xsl:import>
   <xsl:import href="../../commons/fonctions.xsl"></xsl:import>
   <xsl:import href="../../commons/templates.xsl"></xsl:import>
   <xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param>
   <xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param>
   <xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable>
   <xsl:param name="nomenclaturePasEnrichie"></xsl:param>
   <xsl:variable name="nomenclature" select="document('libellePlanCompte.xml')/n:Nomenclature"></xsl:variable>
   <xsl:variable name="data" select="document('libelleAffiche.xml')/data"></xsl:variable>
   <xsl:variable name="isPrint" select="1"></xsl:variable>
   <xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="/dcfu:CompteFinancierUnique"></xsl:template><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         
         
         <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
            
            
            
            
            
            <meta name="generator" content="ODM" />
            
            
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
            
            
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
            
            
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Tahoma;
  panose-1:2 11 6 4 3 5 4 4 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
h3
  {
  
  margin:0cm;
  text-align:center;
  page-break-after:avoid;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;
  font-weight:normal;}
p.MsoHeading8, li.MsoHeading8, div.MsoHeading8
  {
  margin:0cm;
  text-align:center;
  page-break-after:avoid;
  font-size:12.0pt;
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0cm;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
span.Titre8Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.En-tteCar
  {
  
  font-family:"Times New Roman",serif;}
p.BodyText21, li.BodyText21, div.BodyText21
  {
  margin:0cm;
  font-size:9.0pt;
  font-family:"Times New Roman",serif;}
span.Titre3Car
  {
  
  font-family:"Times New Roman",serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:210mm 297mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style>
            </head>
         
         
         
         <body id="ETAT_RSTREALREC" lang="EN-US" style="word-wrap:break-word">
            
            
            <div id="header">
               
               
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &#34;Arial&#34;,&#34;sans-serif&#34;">
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"></xsl:value-of>  - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"></xsl:value-of></span></b></p>
               
               </div>
            
            
            
            
            <div class="WordSection1">
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab1">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        
                        <tr>
                           
                           
                           <td width="89%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoHeading8"><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">I – INFORMATIONS GÉNÉRALES ET SYNTHÉTIQUES</span></p>
                              
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">I</span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="89%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">DETAIL DES RESTES A REALISER - RAR RECETTES</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">D2</span></b></p>
                              
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal" style="margin-top:0cm;margin-right:46.5pt;margin-bottom: 0cm;margin-left:1.0cm;margin-bottom:.0001pt"><span lang="FR" style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal" style="margin-top:0cm;margin-right:46.5pt;margin-bottom: 0cm;margin-left:1.0cm;margin-bottom:.0001pt"><span lang="FR" style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal" style="margin-right:-.05pt"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">DETAIL DES RESTES A REALISER N EN RECETTES (1)</span></b></p>
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab2">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        <xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(not(./n:Fonction/@V)) and (./n:CodRD/@V='R')                         and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0)]"></xsl:variable>
                        
                        
                        <thead>
                           
                           
                           
                           <tr height="0" class="#tech# #fixWidths#">
                              
                              
                              <td width="14.6%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="50.9%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="11.1%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="23.4%" style="border:none" rowspan="1" colspan="1"></td>
                              </tr>
                           
                           
                           
                           <tr style="page-break-inside:avoid">
                              
                              
                              <td width="14.6%" valign="top" style="border:double black 2.25pt; border-right:solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Chap. / art. (2)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="50.9%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Libellé </span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="34.5%" colspan="2" valign="top" style="border:double black 2.25pt; border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Titres restant à émettre </span></b></p>
                                 
                                 </td>
                              </tr>
                           
                           </thead>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           
                           <td width="65.5%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">SECTION D’INVESTISSEMENT – TOTAL</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-bottom:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="BodyText21"><b><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(III)</span></b></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="BodyText21" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINV')]/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm2" select="$varOdm1[(n:ChapitreNature/@V='10') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">10</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '10' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm2/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm3">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='10' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm4">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm3/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm3"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm4/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm5" select="$varOdm1[(n:ChapitreNature/@V='13') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">13</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '13' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm5/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm6">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='13' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm7">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm6/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm6"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm7/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm8" select="$varOdm1[(n:ChapitreNature/@V='16') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">16</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '16' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm8/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm9">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='16' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left; line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm10">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm9/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm9"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm10/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm11" select="$varOdm1[(n:ChapitreNature/@V='18') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">18</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '18' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm11/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm12">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='18' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm13">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm12/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm12"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm13/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm14" select="$varOdm1[(n:ChapitreNature/@V='20') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">20</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0cm 3.5pt 0cm 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <h3 align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '20' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></h3>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm14/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm15">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='20' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0cm 3.5pt 0cm 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <h3 align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></h3>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm16">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm15/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0cm 3.5pt 0cm 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm15"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm16/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm17" select="$varOdm1[(n:ChapitreNature/@V='21') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">21</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '21' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm17/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm18">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='21' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm19">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm18/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-left:none"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm18"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm19/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm20" select="$varOdm1[(n:ChapitreNature/@V='22') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">22</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '22' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm20/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm21">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='22' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm22">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm21/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm21"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm22/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm23" select="$varOdm1[(n:ChapitreNature/@V='23') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">23</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '23' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm23/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm24">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='23' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm25">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm24/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm24"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm25/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm26" select="$varOdm1[(n:ChapitreNature/@V='26') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">26</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '26' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm26/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm27">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='26' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm28">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm27/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm27"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm28/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm29" select="$varOdm1[(n:ChapitreNature/@V='27') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">27</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '27' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm29/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm30">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='27' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm31">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm30/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm30"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm31/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">45</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Chapitres d’opérations pour compte de tiers</span></b></p>
                              
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECOPCT')                                        and (./n:OpBudg/@V='0')]/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm32">
                           
                           
                           <xsl:for-each select="distinct-values($varOdm1[(./n:Nature/@V) and (./n:OpeCpteTiers/@V)]/n:TypNumCpteTiers/@V)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V) and (./n:OpeCpteTiers/@V) and (./n:TypNumCpteTiers/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($ligne/n:Nature/@V)"></xsl:value-of>
                                             
                                             <xsl:value-of select="distinct-values($ligne/n:OpeCpteTiers/@V)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left; line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">Opération pour compte de tiers n° 
                                             
                                             <xsl:value-of select="distinct-values($ligne/n:OpeCpteTiers/@V)"></xsl:value-of> - 
                                             
                                             <xsl:value-of select="distinct-values($ligne/n:LibCpte/@V)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm33">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm32/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm32"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm33/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           
                           <td width="65.5%" colspan="2" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">SECTION D’EXPLOITATION – TOTAL</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border:none;border-bottom:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="BodyText21"><b><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(IV)</span></b></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="BodyText21" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm34" select="$varOdm1[(n:ChapitreNature/@V='70') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">70</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '70' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm34/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm35">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='70' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm36">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm35/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm35"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm36/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm37" select="$varOdm1[(n:ChapitreNature/@V='73') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">73</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '73' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm37/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm38">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='73' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm39">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm38/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm38"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm39/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm40" select="$varOdm1[(n:ChapitreNature/@V='74') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">74</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '74' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm40/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm41">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='74' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm42">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm41/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm41"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm42/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm43" select="$varOdm1[(n:ChapitreNature/@V='75') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">75</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="BodyText21" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '75' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm43/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm44">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='75' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="BodyText21" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm45">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm44/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm44"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm45/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm46" select="$varOdm1[(n:ChapitreNature/@V='013') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">013</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '013' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm46/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm47">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='013' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm48">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm47/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm47"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm48/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm49" select="$varOdm1[(n:ChapitreNature/@V='76') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">76</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '76' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm49/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm50">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='76' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm51">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm50/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm50"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm51/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm52" select="$varOdm1[(n:ChapitreNature/@V='77') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">77</span></b></p>
                              
                              </td>
                           
                           
                           <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="BodyText21" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '77' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm52/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm53">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='77' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="14.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="50.9%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="BodyText21" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; color:black">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="34.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm54">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm53/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="14.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="50.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    
                                    
                                    <td height="1px" width="34.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm53"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm54/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoHeader" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoHeader" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(1) Il s’agit des restes à réaliser établis conformément à la comptabilité d’engagement
                     annuelle. Ces restes à réaliser seront
                     repris au BP ou au BS N+1.</span></p>
               
               
               
               <p class="MsoHeader" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(2) Suivant le niveau de vote retenu par l’assemblée délibérante.</span></p>
               
               </div>
            
            
            
            <div id="footer">
               
               <p xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" class="MsoNormal"><span style="font-size:8.0pt;line-height:115%">
                     
                     <xsl:if test="$HTML_OUTPUT_FORMAT">
                        
                        <xsl:variable name="link1" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"></xsl:variable>
                        
                        <xsl:variable name="link2" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"></xsl:variable>
                        
                        <xsl:variable name="link3" select="'images/return.png'"></xsl:variable>
                        
                        <xsl:variable name="link4" select="'Accueil'"></xsl:variable>
                        
                        <xsl:variable name="link5" select="$link1"></xsl:variable>
                        
                        <xsl:variable name="link6" select="$link2"></xsl:variable>
                        
                        <xsl:call-template name="com:lienOutputImage">
                           
                           <xsl:with-param name="Param_0" select="'images/return.png'"></xsl:with-param>
                           
                           <xsl:with-param name="Param_1" select="$link3"></xsl:with-param>
                           
                           <xsl:with-param name="Param_2" select="$link4"></xsl:with-param>
                           
                           <xsl:with-param name="Param_3" select="$link5"></xsl:with-param>
                           
                           <xsl:with-param name="Param_4" select="$link6"></xsl:with-param>
                           </xsl:call-template>
                        </xsl:if></span></p>
               </div>
            </body>
         
         </html></xsl:template></xsl:stylesheet>