<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:data="http://odm-budgetaire.org/data" xmlns:date="http://exslt.org/dates-and-times" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data">
   <xsl:import href="../../number.xsl"></xsl:import>
   <xsl:import href="../../date.xsl"></xsl:import>
   <xsl:import href="../../table.xsl"></xsl:import>
   <xsl:import href="../../style.xsl"></xsl:import>
   <xsl:import href="../../lien.xsl"></xsl:import>
   <xsl:import href="../../commons/constants.xsl"></xsl:import>
   <xsl:import href="../../commons/fonctions.xsl"></xsl:import>
   <xsl:import href="../../commons/templates.xsl"></xsl:import>
   <xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param>
   <xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param>
   <xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable>
   <xsl:param name="nomenclaturePasEnrichie"></xsl:param>
   <xsl:variable name="nomenclature" select="document('libellePlanCompte.xml')/n:Nomenclature"></xsl:variable>
   <xsl:variable name="data" select="document('libelleAffiche.xml')/data"></xsl:variable>
   <xsl:variable name="isPrint" select="1"></xsl:variable>
   <xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="/dcfu:CompteFinancierUnique"></xsl:template><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         
         
         <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
            
            
            
            
            
            <meta name="generator" content="ODM" />
            
            
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
            
            
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
            
            
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Tahoma;
  panose-1:2 11 6 4 3 5 4 4 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
 /* List Definitions */
 ol
  {margin-bottom:0cm;}
ul
  {margin-bottom:0cm;}
--&gt;
/**/
}</style>
            </head>
         
         
         
         <body id="ETAT_DEPINV" lang="FR" style="word-wrap:break-word">
            
            
            <div id="header">
               
               
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &#34;Arial&#34;,&#34;sans-serif&#34;">
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"></xsl:value-of>  - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"></xsl:value-of></span></b></p>
               
               </div>
            
            
            
            
            <div class="WordSection1">
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab1">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        
                        <tr>
                           
                           
                           <td width="88.8%" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">II – EXECUTION BUDGETAIRE</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.2%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">II</span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="88.8%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span style="font-family:&#34;Arial&#34;,sans-serif">DEPENSES D’INVESTISSEMENT – VUE D’ENSEMBLE</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.2%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span style="font-family:&#34;Arial&#34;,sans-serif">A1.1</span></b></p>
                              
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab2">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        
                        <thead>
                           
                           
                           
                           <tr height="0" class="#tech# #fixWidths#">
                              
                              
                              <td width="6.9%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="34.8%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="13.7%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="12.9%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="18.4%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="13.3%" style="border:none" rowspan="1" colspan="1"></td>
                              </tr>
                           
                           
                           
                           <tr>
                              
                              
                              <td width="6.9%" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitre</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="34.8%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Intitulé</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="13.7%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Prévisions (a)</span></b></p>
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(BP + DM + RAR N-1)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="12.9%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Réalisations</span></b></p>
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">(mandats émis) (b)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="18.4%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taux de réalisation (b/a)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="13.3%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Restes à réaliser au 31/12 (1)</span></b></p>
                                 
                                 </td>
                              </tr>
                           
                           </thead>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:ChapitreNature/@V='018') and                            (./n:CodRD/@V='D') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">018</span></p>
                              
                              </td>
                           
                           
                           <td width="34.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '018' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm1/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm1/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREAL018')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border:none;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm1/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm2" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:ChapitreNature/@V='20') and (./n:CodRD/@V='D')                            and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='TNULL')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">20</span></p>
                              
                              </td>
                           
                           
                           <td width="34.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '20' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (sauf 204)</span></p>
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREAL20')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border:none;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm3" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:ChapitreNature/@V='204') and                            (./n:CodRD/@V='D') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='TNULL')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">204</span></p>
                              
                              </td>
                           
                           
                           <td width="34.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '204' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (6)</span></p>
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREAL204')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border:none;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm4" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:ChapitreNature/@V='21') and (./n:CodRD/@V='D')                            and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='TNULL')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">21</span></p>
                              
                              </td>
                           
                           
                           <td width="34.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '21' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREAL21')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border:none;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm5" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:ChapitreNature/@V='22') and (./n:CodRD/@V='D')                            and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='TNULL')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">22</span></p>
                              
                              </td>
                           
                           
                           <td width="34.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '22' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREAL22')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border:none;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm6" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:ChapitreNature/@V='23') and (./n:CodRD/@V='D')                            and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='TNULL')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">23</span></p>
                              
                              </td>
                           
                           
                           <td width="34.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '23' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREAL23')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border:none;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm7" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVOP_PAR_INFOAPACP')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0cm 3.55pt 0cm 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="34.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des opérations d’équipement (2)</span></p>
                              
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7[(./n:InfoAPCP/@V='T')]/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7[(./n:InfoAPCP/@V='T')]/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREALOPEQPT')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7[(./n:InfoAPCP/@V='T')]/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm8" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXINVEQPT')]"></xsl:variable>
                           
                           
                           <td width="41.7%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses d’équipement</span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm8/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm8/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREALEXEEQPT')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm8/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm9" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:ChapitreNature/@V='10') and (./n:CodRD/@V='D')                            and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">10</span></p>
                              
                              </td>
                           
                           
                           <td width="34.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '10' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREAL10')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border:none;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm10" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:ChapitreNature/@V='13') and                            (./n:CodRD/@V='D') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">13</span></p>
                              
                              </td>
                           
                           
                           <td width="34.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '13' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm10/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm10/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREAL13')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border:none;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm10/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm11" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:ChapitreNature/@V='16') and                            (./n:CodRD/@V='D') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">16</span></p>
                              
                              </td>
                           
                           
                           <td width="34.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '16' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (sauf 1688 non budgétaire)</span></p>
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm11/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm11/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREAL16')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border:none;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm11/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm12" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:ChapitreNature/@V='18') and                            (./n:CodRD/@V='D') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">18</span></p>
                              
                              </td>
                           
                           
                           <td width="34.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '18' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm12/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm12/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREAL18')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border:none;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm12/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm13" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:ChapitreNature/@V='26') and                            (./n:CodRD/@V='D') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">26</span></p>
                              
                              </td>
                           
                           
                           <td width="34.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '26' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm13/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm13/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREAL26')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border:none;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm13/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm14" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:ChapitreNature/@V='27') and                            (./n:CodRD/@V='D') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">27</span></p>
                              
                              </td>
                           
                           
                           <td width="34.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '27' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm14/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm14/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREAL27')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border:none;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm14/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm15" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXINVFINANC')]"></xsl:variable>
                           
                           
                           <td width="41.7%" colspan="2" valign="top" style="border:solid black 1.0pt; border-left:double black 1.5pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses financières</span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm15/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm15/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREALEXEFINAN')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm15/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm16" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPOPCT') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">45</span></p>
                              
                              </td>
                           
                           
                           <td width="34.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitres d’opérations pour compte de tiers (3)</span></p>
                              
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm16/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm16/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREALOPCPT')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm16/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm17" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXINVREL')]"></xsl:variable>
                           
                           
                           <td width="41.7%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses réelles d’investissement</span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm17/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm17/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREALEXEREL')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm17/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm18" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:ChapitreNature/@V='040') and                            (./n:CodRD/@V='D') and (./n:OpBudg/@V='1') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">040</span></i></p>
                              
                              </td>
                           
                           
                           <td width="34.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '040' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (4)</span></i></p>
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm18/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm18/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREAL040')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border:none;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm18/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm19" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:ChapitreNature/@V='041') and                            (./n:CodRD/@V='D') and (./n:OpBudg/@V='1') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="6.9%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">041 </span></i></p>
                              
                              </td>
                           
                           
                           <td width="34.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '041' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (5)</span></i></p>
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm19/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm19/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREAL041')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm19/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:20.4pt">
                           
                           <xsl:variable name="varOdm20" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXINVORD')]"></xsl:variable>
                           
                           
                           <td width="41.7%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;height: 20.4pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses d’ordre en investissement</span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:20.4pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm20/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:20.4pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm20/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:20.4pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREALEXEORD')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:20.4pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm20/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:20.85pt">
                           
                           <xsl:variable name="varOdm21" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXINV')]"></xsl:variable>
                           
                           
                           <td width="41.7%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;height: 20.85pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses d’investissement de l’exercice</span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:20.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm21/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:20.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm21/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:20.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPINVTXREALEXE')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:20.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm21/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm22" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:ChapitreNature/@V='001') and                            (./n:OpBudg/@V='T') and (./n:InfoOpe/@V='T') and (./n:CodRD/@V='D')]"></xsl:variable>
                           
                           
                           <td width="41.7%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">001 Solde d’exécution négatif reporté</span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm22/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0cm 3.55pt 0cm 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="18.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0cm 3.55pt 0cm 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="13.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; background:#A6A6A6;padding:0cm 3.55pt 0cm 3.55pt" rowspan="1" colspan="1"> </td>
                           </tr>
                        
                        
                        <tr style="height:17.25pt">
                           
                           
                           <td width="41.7%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:double black 1.5pt; border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;height: 17.25pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses de la section d’investissement</span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.7%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:17.25pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPTOTINVCA')]/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="12.9%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:17.25pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="EN-US" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPTOTINV')]/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="18.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0cm 3.55pt 0cm 3.55pt;height:17.25pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="13.3%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:17.25pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPTOTINV')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal"><b><span style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 6.0pt;font-family:&#34;Arial&#34;,sans-serif">(1) Dépenses engagées non mandatées.</span></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 6.0pt;font-family:&#34;Arial&#34;,sans-serif">(2) Voir l’état II-C1.1 pour le détail des opérations d’équipement.</span></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 6.0pt;font-family:&#34;Arial&#34;,sans-serif">(3) Voir l’état IV-B5 pour le détail des opérations pour compte de tiers.</span></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 6.0pt;font-family:&#34;Arial&#34;,sans-serif">(4) <i>DI 040 = RF 042</i></span></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 6.0pt;font-family:&#34;Arial&#34;,sans-serif">(5) <i>DI 041 = RI 041</i></span></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 6.0pt;font-family:&#34;Arial&#34;,sans-serif">(6) Le chapitre 204 est un chapitre globalisé qui inclut le 204 et le 2324.</span></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 6.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               </div>
            
            
            
            <div id="footer">
               
               <p xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" class="MsoNormal"><span style="font-size:8.0pt;line-height:115%">
                     
                     <xsl:if test="$HTML_OUTPUT_FORMAT">
                        
                        <xsl:variable name="link1" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"></xsl:variable>
                        
                        <xsl:variable name="link2" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"></xsl:variable>
                        
                        <xsl:variable name="link3" select="'images/return.png'"></xsl:variable>
                        
                        <xsl:variable name="link4" select="'Accueil'"></xsl:variable>
                        
                        <xsl:variable name="link5" select="$link1"></xsl:variable>
                        
                        <xsl:variable name="link6" select="$link2"></xsl:variable>
                        
                        <xsl:call-template name="com:lienOutputImage">
                           
                           <xsl:with-param name="Param_0" select="'images/return.png'"></xsl:with-param>
                           
                           <xsl:with-param name="Param_1" select="$link3"></xsl:with-param>
                           
                           <xsl:with-param name="Param_2" select="$link4"></xsl:with-param>
                           
                           <xsl:with-param name="Param_3" select="$link5"></xsl:with-param>
                           
                           <xsl:with-param name="Param_4" select="$link6"></xsl:with-param>
                           </xsl:call-template>
                        </xsl:if></span></p>
               </div>
            </body>
         
         </html></xsl:template></xsl:stylesheet>