<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:data="http://odm-budgetaire.org/data" xmlns:date="http://exslt.org/dates-and-times" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data">
   <xsl:import href="../../number.xsl"></xsl:import>
   <xsl:import href="../../date.xsl"></xsl:import>
   <xsl:import href="../../table.xsl"></xsl:import>
   <xsl:import href="../../style.xsl"></xsl:import>
   <xsl:import href="../../lien.xsl"></xsl:import>
   <xsl:import href="../../commons/constants.xsl"></xsl:import>
   <xsl:import href="../../commons/fonctions.xsl"></xsl:import>
   <xsl:import href="../../commons/templates.xsl"></xsl:import>
   <xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param>
   <xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param>
   <xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable>
   <xsl:param name="nomenclaturePasEnrichie"></xsl:param>
   <xsl:variable name="nomenclature" select="document('../libellePlanCompte.xml')/n:Nomenclature"></xsl:variable>
   <xsl:variable name="data" select="document('libelleAffiche.xml')/data"></xsl:variable>
   <xsl:variable name="isPrint" select="1"></xsl:variable>
   <xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="/dcfu:CompteFinancierUnique"></xsl:template><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         
         
         <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
            
            
            
            
            
            <meta name="generator" content="ODM" />
            
            
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
            
            
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
            
            
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Tahoma;
  panose-1:2 11 6 4 3 5 4 4 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
h2
  {
  
  margin-top:0in;
  margin-right:-.3pt;
  margin-bottom:0in;
  margin-left:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:12.0pt;
  font-family:"Times New Roman",serif;
  font-weight:normal;}
p.MsoHeading8, li.MsoHeading8, div.MsoHeading8
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:12.0pt;
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoAcetate, li.MsoAcetate, div.MsoAcetate
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:8.0pt;
  font-family:"Tahoma",sans-serif;}
span.En-tteCar
  {
  
  font-family:"Times New Roman",serif;}
span.PieddepageCar
  {
  
  font-family:"Times New Roman",serif;}
span.TextedebullesCar
  {
  
  font-family:"Tahoma",sans-serif;}
span.Titre2Car
  {
  
  font-family:"Times New Roman",serif;}
span.Titre8Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style>
            </head>
         
         
         
         <body id="ETAT_TAUXCTRB" lang="EN-US">
            
            
            <div id="header">
               
               
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &#34;Arial&#34;,&#34;sans-serif&#34;">
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"></xsl:value-of>  - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"></xsl:value-of></span></b></p>
               
               </div>
            
            
            
            
            <div class="WordSection1">
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab1">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        
                        <tr>
                           
                           
                           <td width="90.9%" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">I – INFORMATIONS GÉNÉRALES ET SYNTHÉTIQUES</span></b></p>
                              
                              </td>
                           
                           
                           <td width="9.1%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoHeader"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">I</span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="90.9%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">TAUX DES CONTRIBUTIONS ET PRODUITS AFFERENTS EN N</span></b></p>
                              
                              </td>
                           
                           
                           <td width="9.1%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">F</span></b></p>
                              
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab2">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        
                        <thead>
                           
                           
                           
                           <tr height="0" class="#tech# #fixWidths#">
                              
                              
                              <td width="27.4%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="17.9%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="20.9%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="11.1%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="11%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="11.7%" style="border:none" rowspan="1" colspan="1"></td>
                              </tr>
                           
                           
                           
                           <tr style="page-break-inside:avoid">
                              
                              
                              <td width="45.3%" colspan="2" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Libellés</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="20.9%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taux, coefficient ou forfait appliqués par décision de l’assemblée délibérante</span></b></p>
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">(%, unité ou €)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="11.1%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Variation du taux / N-1</span></b></p>
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">(%)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="11%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Produit voté par l’assemblée délibérante</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="11.6%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Variation du produit / N-1</span></b></p>
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">(%)</span></b></p>
                                 
                                 </td>
                              </tr>
                           
                           </thead>
                        
                        
                        <tr>
                           
                           
                           <td width="100%" colspan="6" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:double black 1.5pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Part régionale des ressources</span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='24')                            and (./n:CodTypeCarburant/@V='01') and (./n:Origine/@V='1')]"></xsl:variable>
                           
                           
                           <td width="27.4%" rowspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">TICPE (majoration définie à l’art. 265 A <i>bis</i> du code des douanes)</span></p>
                              
                              </td>
                           
                           
                           <td width="17.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">SP</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm1/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm1/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm1/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm1/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm1/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm2" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='24')                            and (./n:CodTypeCarburant/@V='02') and (./n:Origine/@V='1')]"></xsl:variable>
                           
                           
                           <td width="17.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">Gazole</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm2/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm3" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='06')                            and (./n:Origine/@V='1')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taxe sur les permis de conduire</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm3/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm4" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='07')                            and (./n:Origine/@V='1')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taxe sur les certificats d’immatriculation des véhicules</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm4/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm5" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='09')                            and (./n:Origine/@V='1')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taxe spéciale de consommation de produits pétroliers (1)</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm5/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm6" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='10')                            and (./n:Origine/@V='1')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taxe sur le transport public aérien et maritime (1)</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm6/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm7" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='11')                            and (./n:Origine/@V='1')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taxe relative à l’octroi de mer (1)</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm7/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm8" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='12')                            and (./n:Origine/@V='1')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Droits assimilés au droit d’octroi de mer auxquels sont soumis les rhums et spiritueux
                                    (1)</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm8/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        <xsl:variable name="varOdm9" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V!='05')                         and (./n:CodSousTypContrib/@V!='06') and (./n:CodSousTypContrib/@V!='07') and (./n:CodSousTypContrib/@V!='09') and (./n:CodSousTypContrib/@V!='10')                         and (./n:CodSousTypContrib/@V!='11') and (./n:CodSousTypContrib/@V!='12') and (./n:CodSousTypContrib/@V!='24') and (./n:Origine/@V='1')]"></xsl:variable>
                        
                        
                        <xsl:variable name="varOdm10">
                           
                           
                           <xsl:for-each select="$varOdm9">
                              
                              <xsl:variable name="ligne" select="."></xsl:variable>
                              
                              
                              <tr>
                                 
                                 
                                 <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                    
                                    
                                    <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:value-of select="distinct-values($ligne/n:LibTaxe/@V)"></xsl:value-of> (2)</span></p>
                                    </td>
                                 
                                 
                                 <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                    
                                    
                                    <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$ligne/n:TxApplicConsMunic/@V"></xsl:with-param>
                                             </xsl:call-template> 
                                          
                                          <xsl:value-of select="distinct-values($ligne/n:Unite/@V)"></xsl:value-of></span></p>
                                    </td>
                                 
                                 
                                 <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                    
                                    
                                    <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$ligne/n:TxVariTx/@V"></xsl:with-param>
                                             </xsl:call-template></span></p>
                                    </td>
                                 
                                 
                                 <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                    
                                    
                                    <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$ligne/n:MtProdVote/@V"></xsl:with-param>
                                             </xsl:call-template></span></p>
                                    </td>
                                 
                                 
                                 <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                    
                                    
                                    <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$ligne/n:TxVariProd/@V"></xsl:with-param>
                                             </xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm11">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm10/*) = 0">
                                 
                                 
                                 <tr class=" #tech#">
                                    
                                    
                                    <td height="1px" width="45.3%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="20.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="11.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="11%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="11.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm10"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm11/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr>
                           
                           
                           <td width="100%" colspan="6" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:double black 1.5pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Part départementale des ressources</span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm12" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='02')                            and (./n:Origine/@V='2')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taxe foncière sur les propriétés bâties</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm12/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm12/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm12/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm12/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm12/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm13" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='23')                            and (./n:Origine/@V='2')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taxe d’aménagement</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm13/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm13/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm13/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm13/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm13/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm14" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='20')                            and (./n:Origine/@V='2')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taxe de publicité foncière et droit d’enregistrement</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm14/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm14/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm14/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm14/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm14/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm15" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='21')                            and (./n:Origine/@V='2')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taxe sur la consommation finale d’électricité</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm15/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm15/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm15/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm15/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm15/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm16" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='22')                            and (./n:Origine/@V='2')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taxe sur les remontées mécaniques des zones de montagne</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm16/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm16/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm16/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm16/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm16/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        <xsl:variable name="varOdm17" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V!='02')                         and (./n:CodSousTypContrib/@V!='20') and (./n:CodSousTypContrib/@V!='21') and (./n:CodSousTypContrib/@V!='22') and (./n:CodSousTypContrib/@V!='23')                         and (./n:Origine/@V='2')]"></xsl:variable>
                        
                        
                        <xsl:variable name="varOdm18">
                           
                           
                           <xsl:for-each select="$varOdm17">
                              
                              <xsl:variable name="ligne" select="."></xsl:variable>
                              
                              
                              <tr>
                                 
                                 
                                 <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                    
                                    
                                    <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:value-of select="distinct-values($ligne/n:LibTaxe/@V)"></xsl:value-of> (2)</span></p>
                                    </td>
                                 
                                 
                                 <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                    
                                    
                                    <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$ligne/n:TxApplicConsMunic/@V"></xsl:with-param>
                                             </xsl:call-template> 
                                          
                                          <xsl:value-of select="distinct-values($ligne/n:Unite/@V)"></xsl:value-of></span></p>
                                    </td>
                                 
                                 
                                 <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                    
                                    
                                    <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$ligne/n:TxVariTx/@V"></xsl:with-param>
                                             </xsl:call-template></span></p>
                                    </td>
                                 
                                 
                                 <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                    
                                    
                                    <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$ligne/n:MtProdVote/@V"></xsl:with-param>
                                             </xsl:call-template></span></p>
                                    </td>
                                 
                                 
                                 <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                    
                                    
                                    <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$ligne/n:TxVariProd/@V"></xsl:with-param>
                                             </xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm19">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm18/*) = 0">
                                 
                                 
                                 <tr class=" #tech#">
                                    
                                    
                                    <td height="1px" width="45.3%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="20.9%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="11.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="11%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="11.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm18"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm19/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr>
                           
                           
                           <td width="100%" colspan="6" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:double black 1.5pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Part communale des ressources</span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm20" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='01')                            and (./n:Origine/@V='3')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taxe d’habitation</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm20/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm20/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm20/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm20/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm20/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm21" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='02')                            and (./n:Origine/@V='3')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">TFPB</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm21/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm21/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm21/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm21/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm21/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm22" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='03')                            and (./n:Origine/@V='3')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif">TFPNB</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm22/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm22/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm22/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm22/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm22/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm23" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='08')                            and (./n:Origine/@V='3')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">CFE</span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm23/n:TxApplicConsMunic/@V"></xsl:with-param>
                                       </xsl:call-template> 
                                    
                                    <xsl:value-of select="distinct-values($varOdm23/n:Unite/@V)"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm23/n:TxVariTx/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm23/n:MtProdVote/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm23/n:TxVariProd/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm24" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_FISCALITE/n:FISCALITE[(./n:CodSousTypContrib/@V='99')]"></xsl:variable>
                           
                           
                           <td width="45.3%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:double black 1.5pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">TOTAL</span></b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"></span></p>
                              
                              </td>
                           
                           
                           <td width="20.9%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; background:#B2B2B2;padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; background:#B2B2B2;padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm24/n:MtProdVote/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm24/n:TxVariProd/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 6.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal" align="left" style="margin-right:35.4pt;text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(1) Taxes perçues par les collectivités d’Outre-mer.</span></p>
               
               
               
               <p class="MsoNormal" align="left" style="margin-right:35.4pt;text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(2) Détailler les taxes pour lesquelles la collectivité a un pouvoir de modulation.</span></p>
               
               </div>
            
            
            
            <div id="footer">
               
               <p xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" class="MsoNormal"><span style="font-size:8.0pt;line-height:115%">
                     
                     <xsl:if test="$HTML_OUTPUT_FORMAT">
                        
                        <xsl:variable name="link1" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"></xsl:variable>
                        
                        <xsl:variable name="link2" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"></xsl:variable>
                        
                        <xsl:variable name="link3" select="'images/return.png'"></xsl:variable>
                        
                        <xsl:variable name="link4" select="'Accueil'"></xsl:variable>
                        
                        <xsl:variable name="link5" select="$link1"></xsl:variable>
                        
                        <xsl:variable name="link6" select="$link2"></xsl:variable>
                        
                        <xsl:call-template name="com:lienOutputImage">
                           
                           <xsl:with-param name="Param_0" select="'images/return.png'"></xsl:with-param>
                           
                           <xsl:with-param name="Param_1" select="$link3"></xsl:with-param>
                           
                           <xsl:with-param name="Param_2" select="$link4"></xsl:with-param>
                           
                           <xsl:with-param name="Param_3" select="$link5"></xsl:with-param>
                           
                           <xsl:with-param name="Param_4" select="$link6"></xsl:with-param>
                           </xsl:call-template>
                        </xsl:if></span></p>
               </div>
            </body>
         
         </html></xsl:template></xsl:stylesheet>