<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:data="http://odm-budgetaire.org/data" xmlns:date="http://exslt.org/dates-and-times" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data">
   <xsl:import href="../../number.xsl"></xsl:import>
   <xsl:import href="../../date.xsl"></xsl:import>
   <xsl:import href="../../table.xsl"></xsl:import>
   <xsl:import href="../../style.xsl"></xsl:import>
   <xsl:import href="../../lien.xsl"></xsl:import>
   <xsl:import href="../../commons/constants.xsl"></xsl:import>
   <xsl:import href="../../commons/fonctions.xsl"></xsl:import>
   <xsl:import href="../../commons/templates.xsl"></xsl:import>
   <xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param>
   <xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param>
   <xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable>
   <xsl:param name="nomenclaturePasEnrichie"></xsl:param>
   <xsl:variable name="nomenclature" select="document('libellePlanCompte.xml')/n:Nomenclature"></xsl:variable>
   <xsl:variable name="data" select="document('libelleAffiche.xml')/data"></xsl:variable>
   <xsl:variable name="isPrint" select="1"></xsl:variable>
   <xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="/dcfu:CompteFinancierUnique"></xsl:template><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         
         
         <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
            
            
            
            
            
            <meta name="generator" content="ODM" />
            
            
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
            
            
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
            
            
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Calibri;
  panose-1:2 15 5 2 2 2 4 3 2 4;}
@font-face
  {font-family:Tahoma;
  panose-1:2 11 6 4 3 5 4 4 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
h3
  {
  
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
h6
  {
  
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:11.0pt;
  font-family:"Times New Roman",serif;}
p.MsoHeading8, li.MsoHeading8, div.MsoHeading8
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:12.0pt;
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.MsoHeading9, li.MsoHeading9, div.MsoHeading9
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:9.0pt;
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:11.0pt;
  font-family:"Calibri",sans-serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:11.0pt;
  font-family:"Calibri",sans-serif;}
p.MsoAcetate, li.MsoAcetate, div.MsoAcetate
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:8.0pt;
  font-family:"Tahoma",sans-serif;}
p.MsoListParagraph, li.MsoListParagraph, div.MsoListParagraph
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpFirst, li.MsoListParagraphCxSpFirst, div.MsoListParagraphCxSpFirst
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpMiddle, li.MsoListParagraphCxSpMiddle, div.MsoListParagraphCxSpMiddle
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpLast, li.MsoListParagraphCxSpLast, div.MsoListParagraphCxSpLast
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
span.En-tteCar
  {
  }
span.PieddepageCar
  {
  }
span.TextedebullesCar
  {
  
  font-family:"Tahoma",sans-serif;}
span.Titre3Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.Titre6Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.Titre8Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.Titre9Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.BodyText21, li.BodyText21, div.BodyText21
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:9.0pt;
  font-family:"Times New Roman",serif;}
p.notedebasdepage2, li.notedebasdepage2, div.notedebasdepage2
  {
  margin-top:0in;
  margin-right:-.4pt;
  margin-bottom:0in;
  margin-left:5.0pt;
  margin-bottom:.0001pt;
  text-align:justify;
  text-autospace:none;
  font-size:6.0pt;
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:210mm 297mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style>
            </head>
         
         
         
         <body id="ETAT_DEPEXP" lang="EN-US">
            
            
            <div id="header">
               
               
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &#34;Arial&#34;,&#34;sans-serif&#34;">
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"></xsl:value-of>  - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"></xsl:value-of></span></b></p>
               
               </div>
            
            
            
            
            <div class="WordSection1">
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab1">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        
                        <tr>
                           
                           
                           <td width="87.5%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoHeading8"><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">II - EXÉCUTION BUDGÉTAIRE</span></p>
                              
                              </td>
                           
                           
                           <td width="12.5%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">II</span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr style="height:7.95pt">
                           
                           
                           <td width="87.5%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height:7.95pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">D</span></b><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">É</span></b><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">PENSES D’EXPLOITATION – VUE D’ENSEMBLE</span></b></p>
                              
                              </td>
                           
                           
                           <td width="12.5%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt;height:7.95pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">A1.1</span></b></p>
                              
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
               
               
               
               <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">DEPENSES D’EXPLOITATION</span></b></p>
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab2">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse">
                        
                        <xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:CodRD/@V='D') and (not(./n:Fonction/@V))                         and (./n:InfoOpe/@V='T')]"></xsl:variable>
                        
                        
                        <thead>
                           
                           
                           
                           <tr height="0" class="#tech# #fixWidths#">
                              
                              
                              <td width="8.4%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="25.9%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="11.6%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="11.3%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="11.4%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="11.4%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="9.9%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="9.9%" style="border:none" rowspan="1" colspan="1"></td>
                              </tr>
                           
                           
                           
                           <tr style="page-break-inside:avoid;height:57.45pt">
                              
                              
                              <td width="8.4%" valign="top" style="border:double black 2.25pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:57.45pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <h6 style="margin-right:-3.55pt"><span lang="FR" style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Chapitre</span></h6>
                                 
                                 </td>
                              
                              
                              <td width="25.9%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:57.45pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoHeading9"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Intitulé </span></p>
                                 
                                 </td>
                              
                              
                              <td width="11.6%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:57.45pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Prévisions (a) </span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="11.3%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:57.45pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Réalisations Mandats émis (b) </span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="11.4%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:57.45pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" style="margin-top:0in;margin-right:-2.4pt;margin-bottom: 0in;margin-left:-.4pt;margin-bottom:.0001pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Rattachements (c) </span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="11.4%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:57.45pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total réalisations (d = b+c) </span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="9.9%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:57.45pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taux de réalisation (d/a)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="9.9%" valign="top" style="border:double black 2.25pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:57.45pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Restes à réaliser (1) </span></b></p>
                                 
                                 </td>
                              </tr>
                           
                           </thead>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm2" select="$varOdm1[(n:ChapitreNature/@V='011') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="8.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitre 011</span></p>
                              
                              </td>
                           
                           
                           <td width="25.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoHeader" style="line-height:115%"><span style="font-size:7.0pt; line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '011' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:CredOuv/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:MtReal/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" style="border-top:none;border-left:none;border-bottom: solid black 1.0pt;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif"> 
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL011')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:MtRAR3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm3" select="$varOdm1[(n:ChapitreNature/@V='012') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="8.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitre 012</span></p>
                              
                              </td>
                           
                           
                           <td width="25.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '012' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:CredOuv/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:MtReal/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif"> 
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL012')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:MtRAR3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm4" select="$varOdm1[(n:ChapitreNature/@V='014') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="8.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitre 014</span></p>
                              
                              </td>
                           
                           
                           <td width="25.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left; line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '014' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:CredOuv/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:MtReal/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif"> 
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL014')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:MtRAR3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm5" select="$varOdm1[(n:ChapitreNature/@V='65') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="8.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitre 65</span></p>
                              
                              </td>
                           
                           
                           <td width="25.9%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '65' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:CredOuv/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:MtReal/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif"> 
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL65')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border:none;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:MtRAR3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           
                           <td width="34.2%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:double black 2.25pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses de gestion courante</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPGESCOUFON')]/n:CredOuv/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPGESCOUFON')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPGESCOUFON')]/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPGESCOUFON')]/n:MtReal/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPGESCOUFONTXREAL')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPGESCOUFON')]/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm6" select="$varOdm1[(n:ChapitreNature/@V='66') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="8.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitre 66</span></p>
                              
                              </td>
                           
                           
                           <td width="25.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <h3 align="left" style="text-align:left;line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; font-weight:normal">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '66' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></h3>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:CredOuv/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:MtReal/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif"> 
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL66')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:MtRAR3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm7" select="$varOdm1[(n:ChapitreNature/@V='67') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="8.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitre 67</span></p>
                              
                              </td>
                           
                           
                           <td width="25.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '67' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:CredOuv/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:MtReal/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif"> 
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL67')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:MtRAR3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm8" select="$varOdm1[(n:ChapitreNature/@V='68') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="8.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="BodyText21"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitre 68</span></p>
                              
                              </td>
                           
                           
                           <td width="25.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoHeader" style="line-height:115%"><span style="font-size:7.0pt; line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '68' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:CredOuv/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:MtReal/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif"> 
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL68')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:MtRAR3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm9" select="$varOdm1[(n:ChapitreNature/@V='69') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="8.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="BodyText21"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitre 69</span></p>
                              
                              </td>
                           
                           
                           <td width="25.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <h3 align="left" style="text-align:left;line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; font-weight:normal">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '69' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span><span style="font-size:7.0pt; line-height:115%;font-family:&#34;Arial&#34;,sans-serif"></span><span style="font-size:7.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; font-weight:normal">(2)</span></h3>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:CredOuv/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:MtReal/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif"> 
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL69')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:MtRAR3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm10" select="$varOdm1[(n:ChapitreNature/@V='022') and (./n:OpBudg/@V='0')]"></xsl:variable>
                           
                           
                           <td width="8.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="BodyText21"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitre 022</span></p>
                              
                              </td>
                           
                           
                           <td width="25.9%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <h3 align="left" style="text-align:left;line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif; font-weight:normal">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '022' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></h3>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm10/n:CredOuv/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:double black 2.25pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           
                           <td width="34.2%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses réelles d’exploitation</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONREL')]/n:CredOuv/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONREL')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONREL')]/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONREL')]/n:MtReal/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><i><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONRELTXREAL')]/n:TxReal3112/@V"></xsl:with-param>
                                             </xsl:call-template></span></i></b></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border:none;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONREL')]/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm11" select="$varOdm1[(n:ChapitreNature/@V='023') and (./n:OpBudg/@V='1')]"></xsl:variable>
                           
                           
                           <td width="8.4%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><i><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitre 023</span></i></p>
                              
                              </td>
                           
                           
                           <td width="25.9%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><i><span style="font-size:7.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '023' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> </span></i></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm11/n:CredOuv/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm12" select="$varOdm1[(n:ChapitreNature/@V='042') and (./n:OpBudg/@V='1')]"></xsl:variable>
                           
                           
                           <td width="8.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><i><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitre 042</span></i></p>
                              
                              </td>
                           
                           
                           <td width="25.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><i><span style="font-size:7.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '042' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (3)</span></i></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm12/n:CredOuv/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm12/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm12/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm12/n:MtReal/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif"> 
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL042')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm12/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm13" select="$varOdm1[(n:ChapitreNature/@V='043') and (./n:OpBudg/@V='1')]"></xsl:variable>
                           
                           
                           <td width="8.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><i><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitre 043</span></i></p>
                              
                              </td>
                           
                           
                           <td width="25.9%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><i><span style="font-size:7.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '043' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (3)</span></i></p>
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm13/n:CredOuv/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm13/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm13/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm13/n:MtReal/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif"> 
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREAL043')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm13/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid;height:7.3pt">
                           
                           
                           <td width="34.2%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:double black 2.25pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 7.3pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses d’ordre d’exploitation</span></i></b></p>
                              
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><i><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONORD')]/n:CredOuv/@V"></xsl:with-param>
                                             </xsl:call-template></span></i></b></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><i><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONORD')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                             </xsl:call-template></span></i></b></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><i><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONORD')]/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                             </xsl:call-template></span></i></b></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><i><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONORD')]/n:MtReal/@V"></xsl:with-param>
                                             </xsl:call-template></span></i></b></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><i><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONORDTXREAL')]/n:TxReal3112/@V"></xsl:with-param>
                                             </xsl:call-template></span></i></b></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><i><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONORD')]/n:MtRAR3112/@V"></xsl:with-param>
                                             </xsl:call-template></span></i></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid;height:11.8pt">
                           
                           
                           <td width="34.2%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:double black 2.25pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 11.8pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses d’exploitation de l’exercice</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:CredOuv/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border:none;border-bottom:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: solid black 1.0pt;border-bottom:double black 2.25pt;border-right: none;padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: solid black 1.0pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:MtReal/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFONTXREAL')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif"></span></b><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid;height:11.8pt">
                           
                           
                           <td width="34.2%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:double black 2.25pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 11.8pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">002 Résultat d’exploitation reporté</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm1[(n:ChapitreNature/@V='002') and (./n:OpBudg/@V='T')]/n:CredOuv/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border:none;border-bottom:double black 2.25pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: solid black 1.0pt;border-bottom:double black 2.25pt;border-right: none;background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: solid black 1.0pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt; height:11.8pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:double black 2.25pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1"> </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid;height:11.8pt">
                           
                           
                           <td width="34.2%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:double black 1.5pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 11.8pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses de la section d’exploitation</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.6%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPTOTFONCA')]/n:CredOuv/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.3%" valign="top" style="border:none;border-bottom:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: solid black 1.0pt;border-bottom:double black 1.5pt;border-right: none;padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="11.4%" valign="top" style="border-top:none;border-left: solid black 1.0pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:MtReal/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 1.5pt;border-right:solid black 1.0pt; background:#BFBFBF;padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
                              
                              </td>
                           
                           
                           <td width="9.9%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 1.5pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt;height:11.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
               
               
               
               <p class="MsoNormal" align="left" style="margin-right:-7.05pt;text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(1) dépenses engagées non mandatées</span></p>
               
               
               
               <p class="MsoNormal" align="left" style="margin-right:-7.05pt;text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(2) ce chapitre n’existe pas en M49</span></p>
               
               
               
               <p class="MsoNormal" align="left" style="margin-right:-7.05pt;text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(3) DE 042 = RI 040 ; DE 043 = RE 043</span></p>
               
               </div>
            
            
            
            <div id="footer">
               
               <p xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" class="MsoNormal"><span style="font-size:8.0pt;line-height:115%">
                     
                     <xsl:if test="$HTML_OUTPUT_FORMAT">
                        
                        <xsl:variable name="link1" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"></xsl:variable>
                        
                        <xsl:variable name="link2" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"></xsl:variable>
                        
                        <xsl:variable name="link3" select="'images/return.png'"></xsl:variable>
                        
                        <xsl:variable name="link4" select="'Accueil'"></xsl:variable>
                        
                        <xsl:variable name="link5" select="$link1"></xsl:variable>
                        
                        <xsl:variable name="link6" select="$link2"></xsl:variable>
                        
                        <xsl:call-template name="com:lienOutputImage">
                           
                           <xsl:with-param name="Param_0" select="'images/return.png'"></xsl:with-param>
                           
                           <xsl:with-param name="Param_1" select="$link3"></xsl:with-param>
                           
                           <xsl:with-param name="Param_2" select="$link4"></xsl:with-param>
                           
                           <xsl:with-param name="Param_3" select="$link5"></xsl:with-param>
                           
                           <xsl:with-param name="Param_4" select="$link6"></xsl:with-param>
                           </xsl:call-template>
                        </xsl:if></span></p>
               </div>
            </body>
         
         </html></xsl:template></xsl:stylesheet>