<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:data="http://odm-budgetaire.org/data" xmlns:date="http://exslt.org/dates-and-times" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data">
   <xsl:import href="../../number.xsl"></xsl:import>
   <xsl:import href="../../date.xsl"></xsl:import>
   <xsl:import href="../../table.xsl"></xsl:import>
   <xsl:import href="../../style.xsl"></xsl:import>
   <xsl:import href="../../lien.xsl"></xsl:import>
   <xsl:import href="../../commons/constants.xsl"></xsl:import>
   <xsl:import href="../../commons/fonctions.xsl"></xsl:import>
   <xsl:import href="../../commons/templates.xsl"></xsl:import>
   <xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param>
   <xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param>
   <xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable>
   <xsl:param name="nomenclaturePasEnrichie"></xsl:param>
   <xsl:variable name="nomenclature" select="document('libellePlanCompte.xml')/n:Nomenclature"></xsl:variable>
   <xsl:variable name="data" select="document('libelleAffiche.xml')/data"></xsl:variable>
   <xsl:variable name="isPrint" select="1"></xsl:variable>
   <xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="/dcfu:CompteFinancierUnique"></xsl:template><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         
         
         <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
            
            
            
            
            
            <meta name="generator" content="ODM" />
            
            
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
            
            
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
            
            
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:Wingdings;
  panose-1:5 0 0 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Calibri;
  panose-1:2 15 5 2 2 2 4 3 2 4;}
@font-face
  {font-family:Tahoma;
  panose-1:2 11 6 4 3 5 4 4 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0cm;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoBodyText3, li.MsoBodyText3, div.MsoBodyText3
  {
  margin:0cm;
  text-align:center;
  font-size:8.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraph, li.MsoListParagraph, div.MsoListParagraph
  {margin-top:0cm;
  margin-right:0cm;
  margin-bottom:0cm;
  margin-left:36.0pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpFirst, li.MsoListParagraphCxSpFirst, div.MsoListParagraphCxSpFirst
  {margin-top:0cm;
  margin-right:0cm;
  margin-bottom:0cm;
  margin-left:36.0pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpMiddle, li.MsoListParagraphCxSpMiddle, div.MsoListParagraphCxSpMiddle
  {margin-top:0cm;
  margin-right:0cm;
  margin-bottom:0cm;
  margin-left:36.0pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpLast, li.MsoListParagraphCxSpLast, div.MsoListParagraphCxSpLast
  {margin-top:0cm;
  margin-right:0cm;
  margin-bottom:0cm;
  margin-left:36.0pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
span.En-tteCar
  {
  }
span.Corpsdetexte3Car
  {
  
  font-family:"Times New Roman",serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
 /* List Definitions */
 ol
  {margin-bottom:0cm;}
ul
  {margin-bottom:0cm;}
--&gt;
/**/
}</style>
            </head>
         
         
         
         <body id="ETAT_MODVOTBDG" lang="FR" style="word-wrap:break-word">
            
            
            <div id="header">
               
               
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &#34;Arial&#34;,&#34;sans-serif&#34;">
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"></xsl:value-of>  - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"></xsl:value-of></span></b></p>
               
               </div>
            
            
            
            
            <div class="WordSection1">
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab1">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        
                        <tr>
                           
                           
                           <td width="86.2%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">II – EXECUTION BUDGETAIRE</span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.8%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">II</span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="86.2%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span style="font-family:&#34;Arial&#34;,sans-serif">MODALITES DE VOTE DU BUDGET</span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.8%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span style="font-family:&#34;Arial&#34;,sans-serif">A</span></b></p>
                              
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoHeader"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab2">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse">
                        
                        
                        <tr>
                           
                           
                           <td width="100%" valign="top" style="border:double black 2.25pt; padding: 0cm 3.5pt 1.5pt 3.5pt;" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif"> </span></p>
                              
                              
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">I – L'assemblée délibérante a voté le budget :</span></p>
                              
                              
                              <p class="MsoListParagraphCxSpFirst" style="margin-left:24.0pt;text-align:justify; text-indent:-18.0pt"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">-<span style="font:7.0pt &#34;Times New Roman&#34;">      </span></span><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">au niveau 
                                    
                                    <xsl:value-of select="distinct-values($data/data:LibelleNatVoteI/data:valeur[@value = $docbudg//n:Budget/n:BlocBudget/n:NatVote/@V]/text())"></xsl:value-of> (1) pour la section d’investissement ;</span></p>
                              
                              
                              <p class="MsoListParagraphCxSpLast" style="margin-left:24.0pt;text-align:justify; text-indent:-18.0pt"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">-<span style="font:7.0pt &#34;Times New Roman&#34;">      </span></span><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">au niveau 
                                    
                                    <xsl:value-of select="distinct-values($data/data:LibelleNatVoteF/data:valeur[@value = $docbudg//n:Budget/n:BlocBudget/n:NatVote/@V]/text())"></xsl:value-of> (1) pour la section de fonctionnement ;</span></p>
                              
                              
                              <p class="MsoNormal" style="margin-left:24.0pt;text-align:justify;text-indent: -18.0pt"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">-<span style="font:7.0pt &#34;Times New Roman&#34;">      </span></span><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values($data/data:LibelleOpeEquip/data:valeur[@value = $docbudg//n:Budget/n:BlocBudget/n:OpeEquip/@V]/text())"></xsl:value-of> (2) vote formel sur les chapitres « opérations d’équipement » ;</span></p>
                              
                              
                              <p class="MsoNormal" style="margin-left:24.0pt;text-align:justify;text-indent: -18.0pt"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">-<span style="font:7.0pt &#34;Times New Roman&#34;">      </span></span><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values($data/data:LibelleVoteFormelChap/data:valeur[@value = $docbudg//n:Budget/n:BlocBudget/n:VoteFormelChap/@V]/text())"></xsl:value-of> (2) vote formel sur chacun des chapitres.</span></p>
                              
                              
                              <p class="MsoBodyText3" align="left" style="text-align:left"><span style="font-family:&#34;Arial&#34;,sans-serif"> </span></p>
                              
                              
                              <p class="MsoBodyText3" align="left" style="text-align:left"><span style="font-family:&#34;Arial&#34;,sans-serif">La liste des articles spécialisés sur lesquels l'ordonnateur ne peut procéder à des
                                    virements d'article à article est la suivante
                                    :</span></p>
                              
                              
                              <xsl:variable name="varOdmTmpTab3">
                                 
                                 
                                 <table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                                    
                                    
                                    <xsl:variable name="varOdm1">
                                       
                                       
                                       <xsl:for-each select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:ArtSpe/@V='true')]/n:Nature/@V)">
                                          
                                          
                                          <xsl:sort select="."></xsl:sort>
                                          
                                          
                                          <xsl:variable name="codeBoucle" select="."></xsl:variable>
                                          
                                          <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:Nature/@V=$codeBoucle) and (./n:ArtSpe/@V='true')]"></xsl:variable>
                                          
                                          
                                          <xsl:if test="$ligne">
                                             
                                             
                                             <tr>
                                                
                                                
                                                <td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                                                   
                                                   
                                                   <p class="MsoBodyText3" align="left" style="text-align:left"><span lang="EN-US" style="font-family:&#34;Arial&#34;,sans-serif;color:black">
                                                         
                                                         <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                                   </td>
                                                </tr>
                                             </xsl:if>
                                          </xsl:for-each>
                                       </xsl:variable>
                                    
                                    
                                    <xsl:variable name="varOdm2">
                                       
                                       
                                       <xsl:choose>
                                          
                                          
                                          <xsl:when test="count($varOdm1/*) = 0">
                                             
                                             
                                             <tr class=" #tech#">
                                                
                                                
                                                <td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td>
                                                </tr>
                                             </xsl:when>
                                          
                                          
                                          <xsl:otherwise>
                                             
                                             
                                             <xsl:sequence select="$varOdm1"></xsl:sequence>
                                             </xsl:otherwise>
                                          </xsl:choose>
                                       </xsl:variable>
                                    
                                    
                                    <xsl:call-template name="table:processRowBorders">
                                       
                                       
                                       <xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param>
                                       
                                       
                                       <xsl:with-param name="rows" select="$varOdm2/xhtml:tr"></xsl:with-param>
                                       </xsl:call-template>
                                    </table>
                                 </xsl:variable>
                              
                              
                              <xsl:call-template name="table:outputTable">
                                 
                                 
                                 <xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param>
                                 </xsl:call-template>
                              
                              
                              <p class="MsoNormal" style="text-align:justify"><span lang="EN-US" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
                              
                              
                              <p class="MsoNormal" style="text-align:justify"><span lang="EN-US" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">II –</span><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">En l’absence de mention au paragraphe I ci-dessus, le budget est réputé voté par chapitre,
                                    sans vote formel sur chacun des
                                    chapitres, en fonctionnement, et en investissement sans vote formel pour les chapitres
                                    « opération d’équipement ».</span></p>
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">III – Conformément à l’article L. 5217-10-6 du CGCT, l’assemblée délibérante autorise
                                    le président à opérer des virements
                                    de crédits de paiement de chapitre à chapitre, à l’exclusion des crédits relatifs
                                    aux dépenses de personnel, dans les limites
                                    suivantes (3) :</span></p>
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">        - Fonctionnement :  
                                    
                                    <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='LimiteVirementCPFonc')]/@V)"></xsl:value-of>%</span></p>
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">        - Investissement :  
                                    
                                    <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:InformationsGenerales/n:Information[(@Code='LimiteVirementCPInvest')]/@V)"></xsl:value-of>%</span></p>
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">IV – En l’absence de mention au paragraphe III ci-dessus, le président est réputé
                                    ne pas avoir reçu l’autorisation de l’assemblée
                                    délibérante de pratiquer des virements de crédits de paiement</span></p>
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">de chapitre à chapitre.</span></p>
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
                              
                              
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">V – Les provisions sont 
                                    
                                    <xsl:value-of select="distinct-values($data/data:LibelleTypProv/data:valeur[@value = $docbudg//n:Budget/n:BlocBudget/n:TypProv/@V]/text())"></xsl:value-of> 
                                    
                                    <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:RefProv/@V)"></xsl:value-of> (4).</span></p>
                              
                              
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif"> </span></p>
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal" style="text-align:justify"><span style="font-size:6.0pt; font-family:&#34;Arial&#34;,sans-serif">(1) A compléter par « du chapitre » ou « de l’article ».</span></p>
               
               
               
               <p class="MsoNormal" style="text-align:justify"><span style="font-size:6.0pt; font-family:&#34;Arial&#34;,sans-serif">(2) Indiquer « avec » ou « sans » vote formel.</span></p>
               
               
               
               <p class="MsoNormal" style="text-align:justify"><span style="font-size:6.0pt; font-family:&#34;Arial&#34;,sans-serif">(3) Au maximum dans la limite de 7.5 % des dépenses réelles de chaque section</span><span style="font-size:6.0pt; font-family:&#34;Arial&#34;,sans-serif">.</span></p>
               
               
               
               <p class="MsoNormal" style="text-align:justify"><span style="font-size:6.0pt; font-family:&#34;Arial&#34;,sans-serif">(4) A compléter par un seul des deux choix suivants, selon les dispositions législatives
                     et réglementaires applicables à la
                     collectivité :</span></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">- semi budgétaire ;</span></p>
               
               
               
               <p class="MsoNormal" style="text-align:justify"><span style="font-size:6.0pt; font-family:&#34;Arial&#34;,sans-serif">- budgétaire par délibération N°… du ...</span></p>
               
               </div>
            
            
            
            <div id="footer">
               
               <p xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" class="MsoNormal"><span style="font-size:8.0pt;line-height:115%">
                     
                     <xsl:if test="$HTML_OUTPUT_FORMAT">
                        
                        <xsl:variable name="link1" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"></xsl:variable>
                        
                        <xsl:variable name="link2" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"></xsl:variable>
                        
                        <xsl:variable name="link3" select="'images/return.png'"></xsl:variable>
                        
                        <xsl:variable name="link4" select="'Accueil'"></xsl:variable>
                        
                        <xsl:variable name="link5" select="$link1"></xsl:variable>
                        
                        <xsl:variable name="link6" select="$link2"></xsl:variable>
                        
                        <xsl:call-template name="com:lienOutputImage">
                           
                           <xsl:with-param name="Param_0" select="'images/return.png'"></xsl:with-param>
                           
                           <xsl:with-param name="Param_1" select="$link3"></xsl:with-param>
                           
                           <xsl:with-param name="Param_2" select="$link4"></xsl:with-param>
                           
                           <xsl:with-param name="Param_3" select="$link5"></xsl:with-param>
                           
                           <xsl:with-param name="Param_4" select="$link6"></xsl:with-param>
                           </xsl:call-template>
                        </xsl:if></span></p>
               </div>
            </body>
         
         </html></xsl:template></xsl:stylesheet>