<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:data="http://odm-budgetaire.org/data" xmlns:date="http://exslt.org/dates-and-times" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data">
   <xsl:import href="../../number.xsl"></xsl:import>
   <xsl:import href="../../date.xsl"></xsl:import>
   <xsl:import href="../../table.xsl"></xsl:import>
   <xsl:import href="../../style.xsl"></xsl:import>
   <xsl:import href="../../lien.xsl"></xsl:import>
   <xsl:import href="../../commons/constants.xsl"></xsl:import>
   <xsl:import href="../../commons/fonctions.xsl"></xsl:import>
   <xsl:import href="../../commons/templates.xsl"></xsl:import>
   <xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param>
   <xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param>
   <xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable>
   <xsl:param name="nomenclaturePasEnrichie"></xsl:param>
   <xsl:variable name="nomenclature" select="document('libellePlanCompte.xml')/n:Nomenclature"></xsl:variable>
   <xsl:variable name="data" select="document('libelleAffiche.xml')/data"></xsl:variable>
   <xsl:variable name="isPrint" select="1"></xsl:variable>
   <xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="/dcfu:CompteFinancierUnique"></xsl:template><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         
         
         <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
            
            
            
            
            
            <meta name="generator" content="ODM" />
            
            
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
            
            
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
            
            
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Tahoma;
  panose-1:2 11 6 4 3 5 4 4 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
h3
  {
  
  margin:0cm;
  text-align:center;
  page-break-after:avoid;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoHeading8, li.MsoHeading8, div.MsoHeading8
  {
  margin:0cm;
  text-align:center;
  page-break-after:avoid;
  font-size:12.0pt;
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0cm;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
span.Titre3Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.Titre8Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.En-tteCar
  {
  
  font-family:"Times New Roman",serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:210mm 297mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style>
            </head>
         
         
         
         <body id="ETAT_OPEEQUIP" lang="EN-US" style="word-wrap:break-word">
            
            
            <div id="header">
               
               
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &#34;Arial&#34;,&#34;sans-serif&#34;">
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"></xsl:value-of>  - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"></xsl:value-of></span></b></p>
               
               </div>
            
            
            <xsl:variable name="eltsBoucleEtat" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:InfoOpe/@V='DETAIL')]/n:Operation/@V"></xsl:variable>
            
            
            <xsl:choose>
               
               
               <xsl:when test="count(distinct-values($eltsBoucleEtat))=0">
                  
                  
                  <xsl:variable name="varOdmTmpTab1">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        
                        <tr>
                           
                           
                           <td width="87.4%" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">II - EXÉCUTION BUDGÉTAIRE </span></b></p>
                              
                              </td>
                           
                           
                           <td width="12.6%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">II</span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="87.4%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoHeading8"><span lang="FR" style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">OPERATIONS D’EQUIPEMENT  - DETAIL DES CHAPITRES ET ARTICLES</span></p>
                              
                              </td>
                           
                           
                           <td width="12.6%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">D</span></b></p>
                              
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param>
                     </xsl:call-template><br xmlns:odm="http://www.axyus.com/2010/odm" xmlns:uuid="java:java.util.UUID" xmlns:xf="java:com.axyus.odm.docbudg.transformation.xslt_ext.OdmXsltExtensions" xmlns:xs="http://www.w3.org/2001/XMLSchema" /><p xmlns:odm="http://www.axyus.com/2010/odm" xmlns:uuid="java:java.util.UUID" xmlns:xf="java:com.axyus.odm.docbudg.transformation.xslt_ext.OdmXsltExtensions" xmlns:xs="http://www.w3.org/2001/XMLSchema" class="normalText">Cet état ne contient pas d'information.</p>
                  </xsl:when>
               
               
               <xsl:otherwise>
                  
                  
                  <xsl:for-each select="distinct-values($eltsBoucleEtat)">
                     
                     
                     <xsl:sort select="."></xsl:sort>
                     
                     
                     <xsl:variable name="codeBoucleEtat" select="."></xsl:variable>
                     
                     
                     <xsl:if test="position() &gt; 1">
                        
                        
                        <div style="page-break-before : always;"></div>
                        </xsl:if>
                     
                     <xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:Operation/@V=$codeBoucleEtat)]"></xsl:variable>
                     
                     
                     
                     
                     <div class="WordSection1">
                        
                        
                        
                        <div align="center">
                           
                           
                           
                           <xsl:variable name="varOdmTmpTab2">
                              
                              
                              <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                                 
                                 
                                 <tr>
                                    
                                    
                                    <td width="87.4%" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">II - EXÉCUTION BUDGÉTAIRE </span></b></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="12.6%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">II</span></b></p>
                                       
                                       </td>
                                    </tr>
                                 
                                 
                                 <tr>
                                    
                                    
                                    <td width="87.4%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoHeading8"><span lang="FR" style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">OPERATIONS D’EQUIPEMENT  - DETAIL DES CHAPITRES ET ARTICLES</span></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="12.6%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">D</span></b></p>
                                       
                                       </td>
                                    </tr>
                                 </table>
                              </xsl:variable>
                           
                           
                           <xsl:call-template name="table:outputTable">
                              
                              
                              <xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param>
                              </xsl:call-template>
                           
                           </div>
                        
                        
                        
                        <p class="MsoNormal" style="margin-right:2.55pt"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
                        
                        
                        
                        <p class="MsoNormal" style="margin-right:2.55pt"><b><span style="font-family: &#34;Arial&#34;,sans-serif">OPERATION D’EQUIPEMENT N°: 
                                 
                                 <xsl:value-of select="distinct-values($codeBoucleEtat)"></xsl:value-of> (1)</span></b></p>
                        
                        
                        
                        <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">LIBELLE : 
                                 
                                 <xsl:value-of select="distinct-values($varOdm1/n:LibCpte/@V)"></xsl:value-of></span></b></p>
                        
                        
                        
                        <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
                        
                        
                        
                        <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">
                                 
                                 <xsl:value-of select="distinct-values($data/data:LibelleTypOpe/data:valeur[@value = $varOdm1/n:CaracSup[@Code='TypOpe']/@V]/text())"></xsl:value-of></span></b></p>
                        
                        
                        
                        <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
                        
                        
                        
                        <div align="center">
                           
                           
                           
                           <xsl:variable name="varOdmTmpTab3">
                              
                              
                              <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                                 
                                 <xsl:variable name="varOdm2" select="$varOdm1[(./n:CodRD/@V='D') and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0')]"></xsl:variable>
                                 
                                 
                                 <thead>
                                    
                                    
                                    
                                    <tr height="0" class="#tech# #fixWidths#">
                                       
                                       
                                       <td width="11.6%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="23.5%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="12.8%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="1.5%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="11.4%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="12.7%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="12.7%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="2.7%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="11.1%" style="border:none" rowspan="1" colspan="1"></td>
                                       </tr>
                                    
                                    
                                    
                                    <tr style="page-break-inside:avoid;height:20.95pt">
                                       
                                       
                                       <td width="35.1%" colspan="2" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0cm 3.55pt 0cm 3.55pt;height:20.95pt" rowspan="1"> </td>
                                       
                                       
                                       <td width="51.1%" colspan="5" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:20.95pt" rowspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Eléments afférents à l’exercice</span></b></p>
                                          
                                          </td>
                                       
                                       
                                       <td width="13.6%" colspan="2" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:20.95pt" rowspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Pour mémoire</span></b></p>
                                          
                                          </td>
                                       </tr>
                                    
                                    
                                    
                                    <tr style="page-break-inside:avoid;height:33.1pt">
                                       
                                       
                                       <td width="11.6%" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:33.1pt" rowspan="1" colspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Chap./Art. (2)</span></b></p>
                                          
                                          </td>
                                       
                                       
                                       <td width="23.5%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:33.1pt" rowspan="1" colspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal" style="margin-right:2.55pt;text-align:justify"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Libellé </span></b></p>
                                          
                                          </td>
                                       
                                       
                                       <td width="12.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:33.1pt" rowspan="1" colspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Prévisions (a) </span></b></p>
                                          
                                          </td>
                                       
                                       
                                       <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:33.1pt" rowspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Réalisations – mandats émis (b) </span></b></p>
                                          
                                          </td>
                                       
                                       
                                       <td width="12.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:33.1pt" rowspan="1" colspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taux de réalisation (b/a)</span></b></p>
                                          
                                          </td>
                                       
                                       
                                       <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:33.1pt" rowspan="1" colspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Restes à réaliser (3) </span></b></p>
                                          
                                          </td>
                                       
                                       
                                       <td width="13.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:33.1pt" rowspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Cumul des réalisations (4)</span></b></p>
                                          
                                          </td>
                                       </tr>
                                    
                                    </thead>
                                 
                                 
                                 <tr style="page-break-inside:avoid;height:27.4pt">
                                    
                                    
                                    <td width="35.1%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:double black 2.25pt;padding: 0cm 3.55pt 1.5pt 3.55pt; height:27.4pt" rowspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">DEPENSES</span></b></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0cm 3.55pt 0cm 3.55pt;height:27.4pt" rowspan="1" colspan="1">
                                       
                                       
                                       <h3 align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GDEPINVOP')]/n:CredOuv/@V"></xsl:with-param>
                                                </xsl:call-template></span></h3>
                                       </td>
                                    
                                    
                                    <td width="1.5%" valign="top" style="border:none;border-bottom:solid black 1.0pt; padding:0cm 3.55pt 0cm 3.55pt;height:27.4pt" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <h3 align="left" style="margin-right:2.55pt;text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">A</span></h3>
                                       
                                       </td>
                                    
                                    
                                    <td width="11.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0cm 3.55pt 0cm 3.55pt;height:27.4pt" rowspan="1" colspan="1">
                                       
                                       
                                       <h3 align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GDEPINVOP')]/n:MtReal/@V"></xsl:with-param>
                                                </xsl:call-template></span></h3>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0cm 3.55pt 0cm 3.55pt;height:27.4pt" rowspan="1" colspan="1">
                                       
                                       
                                       <h3 align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GDEPINVOPTXREAL')]/n:TxReal3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></h3>
                                       </td>
                                    
                                    
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0cm 3.55pt 0cm 3.55pt;height:27.4pt" rowspan="1" colspan="1">
                                       
                                       
                                       <h3 align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GDEPINVOP')]/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></h3>
                                       </td>
                                    
                                    
                                    <td width="2.6%" valign="top" style="border:none;border-bottom:solid black 1.0pt; padding:0cm 3.55pt 0cm 3.55pt;height:27.4pt" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <h3 align="left" style="margin-right:2.55pt;text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">B</span></h3>
                                       
                                       </td>
                                    
                                    
                                    <td width="11.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0cm 3.55pt 0cm 3.55pt;height:27.4pt" rowspan="1" colspan="1">
                                       
                                       
                                       <h3 align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GDEPINVOP')]/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                </xsl:call-template></span></h3>
                                       </td>
                                    </tr>
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    <xsl:variable name="varOdm3" select="$varOdm2[(starts-with(./n:Nature/@V, '20'))]"></xsl:variable>
                                    
                                    
                                    <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">Total chapitre 20</span></b></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="23.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '20' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm3/n:CredOuv/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm3/n:MtReal/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GDEPINVOPTXREAL20')]/n:TxReal3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm3/n:MtRAR3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="13.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm3/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    </tr>
                                 
                                 
                                 <xsl:variable name="varOdm4">
                                    
                                    
                                    <xsl:for-each select="distinct-values($varOdm2[(starts-with(./n:Nature/@V, '20'))]/n:Nature/@V)">
                                       
                                       
                                       <xsl:sort select="."></xsl:sort>
                                       
                                       
                                       <xsl:variable name="codeBoucle" select="."></xsl:variable>
                                       
                                       <xsl:variable name="ligne" select="$varOdm2[(./n:Nature/@V=$codeBoucle) and (starts-with(./n:Nature/@V, '20'))]"></xsl:variable>
                                       
                                       
                                       <xsl:if test="$ligne">
                                          
                                          
                                          <tr style="height:5.6pt">
                                             
                                             
                                             <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">
                                                      
                                                      <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                                </td>
                                             
                                             
                                             <td width="23.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black">
                                                      
                                                      <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black"></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:CredOuv/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtReal/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#BFBFBF;padding:0cm 3.55pt 0cm 3.55pt;height:5.6pt" rowspan="1" colspan="1"> </td>
                                             
                                             
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="13.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             </tr>
                                          </xsl:if>
                                       </xsl:for-each>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:variable name="varOdm5">
                                    
                                    
                                    <xsl:choose>
                                       
                                       
                                       <xsl:when test="count($varOdm4/*) = 0">
                                          
                                          
                                          <tr class=" #tech#" style="page-break-inside:avoid">
                                             
                                             
                                             <td height="1px" width="11.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="23.5%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="13.6%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             </tr>
                                          </xsl:when>
                                       
                                       
                                       <xsl:otherwise>
                                          
                                          
                                          <xsl:sequence select="$varOdm4"></xsl:sequence>
                                          </xsl:otherwise>
                                       </xsl:choose>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:call-template name="table:processRowBorders">
                                    
                                    
                                    <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                                    
                                    
                                    <xsl:with-param name="rows" select="$varOdm5/xhtml:tr"></xsl:with-param>
                                    </xsl:call-template>
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    <xsl:variable name="varOdm6" select="$varOdm2[(starts-with(./n:Nature/@V, '21'))]"></xsl:variable>
                                    
                                    
                                    <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">Total chapitre 21</span></b></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="23.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '21' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm6/n:CredOuv/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm6/n:MtReal/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GDEPINVOPTXREAL21')]/n:TxReal3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm6/n:MtRAR3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="13.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm6/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    </tr>
                                 
                                 
                                 <xsl:variable name="varOdm7">
                                    
                                    
                                    <xsl:for-each select="distinct-values($varOdm2[(starts-with(./n:Nature/@V, '21'))]/n:Nature/@V)">
                                       
                                       
                                       <xsl:sort select="."></xsl:sort>
                                       
                                       
                                       <xsl:variable name="codeBoucle" select="."></xsl:variable>
                                       
                                       <xsl:variable name="ligne" select="$varOdm2[(./n:Nature/@V=$codeBoucle) and (starts-with(./n:Nature/@V, '21'))]"></xsl:variable>
                                       
                                       
                                       <xsl:if test="$ligne">
                                          
                                          
                                          <tr style="height:5.6pt">
                                             
                                             
                                             <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                                </td>
                                             
                                             
                                             <td width="23.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black">
                                                      
                                                      <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black"></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:CredOuv/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtReal/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#BFBFBF;padding:0cm 3.55pt 0cm 3.55pt;height:5.6pt" rowspan="1" colspan="1"> </td>
                                             
                                             
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="13.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             </tr>
                                          </xsl:if>
                                       </xsl:for-each>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:variable name="varOdm8">
                                    
                                    
                                    <xsl:choose>
                                       
                                       
                                       <xsl:when test="count($varOdm7/*) = 0">
                                          
                                          
                                          <tr class=" #tech#" style="page-break-inside:avoid">
                                             
                                             
                                             <td height="1px" width="11.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="23.5%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="13.6%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             </tr>
                                          </xsl:when>
                                       
                                       
                                       <xsl:otherwise>
                                          
                                          
                                          <xsl:sequence select="$varOdm7"></xsl:sequence>
                                          </xsl:otherwise>
                                       </xsl:choose>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:call-template name="table:processRowBorders">
                                    
                                    
                                    <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                                    
                                    
                                    <xsl:with-param name="rows" select="$varOdm8/xhtml:tr"></xsl:with-param>
                                    </xsl:call-template>
                                 
                                 
                                 <tr style="page-break-inside:avoid;height:17.4pt">
                                    
                                    <xsl:variable name="varOdm9" select="$varOdm2[(starts-with(./n:Nature/@V, '22'))]"></xsl:variable>
                                    
                                    
                                    <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:17.4pt" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">Total chapitre 22</span></b></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="23.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:17.4pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '22' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:17.4pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm9/n:CredOuv/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:17.4pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm9/n:MtReal/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:17.4pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GDEPINVOPTXREAL22')]/n:TxReal3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:17.4pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm9/n:MtRAR3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="13.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:17.4pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm9/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    </tr>
                                 
                                 
                                 <xsl:variable name="varOdm10">
                                    
                                    
                                    <xsl:for-each select="distinct-values($varOdm2[(starts-with(./n:Nature/@V, '22'))]/n:Nature/@V)">
                                       
                                       
                                       <xsl:sort select="."></xsl:sort>
                                       
                                       
                                       <xsl:variable name="codeBoucle" select="."></xsl:variable>
                                       
                                       <xsl:variable name="ligne" select="$varOdm2[(./n:Nature/@V=$codeBoucle) and (starts-with(./n:Nature/@V, '22'))]"></xsl:variable>
                                       
                                       
                                       <xsl:if test="$ligne">
                                          
                                          
                                          <tr style="height:5.6pt">
                                             
                                             
                                             <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                                </td>
                                             
                                             
                                             <td width="23.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black">
                                                      
                                                      <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black"></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:CredOuv/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtReal/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#BFBFBF;padding:0cm 3.55pt 0cm 3.55pt;height:5.6pt" rowspan="1" colspan="1"> </td>
                                             
                                             
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="13.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                         
                                                         <xsl:call-template name="num:number">
                                                            
                                                            <xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                            </xsl:call-template></span></b></p>
                                                </td>
                                             </tr>
                                          </xsl:if>
                                       </xsl:for-each>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:variable name="varOdm11">
                                    
                                    
                                    <xsl:choose>
                                       
                                       
                                       <xsl:when test="count($varOdm10/*) = 0">
                                          
                                          
                                          <tr class=" #tech#" style="page-break-inside:avoid;height:17.4pt">
                                             
                                             
                                             <td height="1px" width="11.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="23.5%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="13.6%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             </tr>
                                          </xsl:when>
                                       
                                       
                                       <xsl:otherwise>
                                          
                                          
                                          <xsl:sequence select="$varOdm10"></xsl:sequence>
                                          </xsl:otherwise>
                                       </xsl:choose>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:call-template name="table:processRowBorders">
                                    
                                    
                                    <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                                    
                                    
                                    <xsl:with-param name="rows" select="$varOdm11/xhtml:tr"></xsl:with-param>
                                    </xsl:call-template>
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    <xsl:variable name="varOdm12" select="$varOdm2[(starts-with(./n:Nature/@V, '23'))]"></xsl:variable>
                                    
                                    
                                    <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">Total chapitre 23</span></b></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="23.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '23' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm12/n:CredOuv/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm12/n:MtReal/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GDEPINVOPTXREAL23')]/n:TxReal3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm12/n:MtRAR3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="13.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm12/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    </tr>
                                 
                                 
                                 <xsl:variable name="varOdm13">
                                    
                                    
                                    <xsl:for-each select="distinct-values($varOdm2[(starts-with(./n:Nature/@V, '23'))]/n:Nature/@V)">
                                       
                                       
                                       <xsl:sort select="."></xsl:sort>
                                       
                                       
                                       <xsl:variable name="codeBoucle" select="."></xsl:variable>
                                       
                                       <xsl:variable name="ligne" select="$varOdm2[(./n:Nature/@V=$codeBoucle) and (starts-with(./n:Nature/@V, '23'))]"></xsl:variable>
                                       
                                       
                                       <xsl:if test="$ligne">
                                          
                                          
                                          <tr style="page-break-inside:avoid">
                                             
                                             
                                             <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                                </td>
                                             
                                             
                                             <td width="23.5%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black">
                                                      
                                                      <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black"></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:CredOuv/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtReal/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; background:#BFBFBF;padding:0cm 3.55pt 0cm 3.55pt" rowspan="1" colspan="1"> </td>
                                             
                                             
                                             <td width="12.7%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="13.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             </tr>
                                          </xsl:if>
                                       </xsl:for-each>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:variable name="varOdm14">
                                    
                                    
                                    <xsl:choose>
                                       
                                       
                                       <xsl:when test="count($varOdm13/*) = 0">
                                          
                                          
                                          <tr class=" #tech#" style="page-break-inside:avoid">
                                             
                                             
                                             <td height="1px" width="11.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="23.5%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="13.6%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             </tr>
                                          </xsl:when>
                                       
                                       
                                       <xsl:otherwise>
                                          
                                          
                                          <xsl:sequence select="$varOdm13"></xsl:sequence>
                                          </xsl:otherwise>
                                       </xsl:choose>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:call-template name="table:processRowBorders">
                                    
                                    
                                    <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                                    
                                    
                                    <xsl:with-param name="rows" select="$varOdm14/xhtml:tr"></xsl:with-param>
                                    </xsl:call-template>
                                 </table>
                              </xsl:variable>
                           
                           
                           <xsl:call-template name="table:outputTable">
                              
                              
                              <xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param>
                              </xsl:call-template>
                           
                           </div>
                        
                        
                        
                        <p class="MsoNormal" style="margin-right:2.55pt"><span lang="FR" style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
                        
                        
                        
                        <div align="center">
                           
                           
                           
                           <xsl:variable name="varOdmTmpTab4">
                              
                              
                              <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse">
                                 
                                 <xsl:variable name="varOdm15" select="$varOdm1[(./n:CodRD/@V='R') and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0')]"></xsl:variable>
                                 
                                 
                                 <thead>
                                    
                                    
                                    
                                    <tr height="0" class="#tech# #fixWidths#">
                                       
                                       
                                       <td width="11.6%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="6.1%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="17.7%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="12.8%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="1.3%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="11.3%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="13%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="12.8%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="2.4%" style="border:none" rowspan="1" colspan="1"></td>
                                       
                                       
                                       <td width="10.9%" style="border:none" rowspan="1" colspan="1"></td>
                                       </tr>
                                    
                                    
                                    
                                    <tr style="page-break-inside:avoid;height:19.15pt">
                                       
                                       
                                       <td width="35.2%" colspan="3" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0cm 3.55pt 0cm 3.55pt;height:19.15pt" rowspan="1"> </td>
                                       
                                       
                                       <td width="51%" colspan="5" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:19.15pt" rowspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Eléments afférents à l’exercice</span></b></p>
                                          
                                          </td>
                                       
                                       
                                       <td width="13.4%" colspan="2" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:19.15pt" rowspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Pour mémoire</span></b></p>
                                          
                                          </td>
                                       </tr>
                                    
                                    
                                    
                                    <tr style="page-break-inside:avoid;height:37.6pt">
                                       
                                       
                                       <td width="17.7%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt; height:37.6pt" rowspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Recettes (répartition)</span></b></p>
                                          
                                          
                                          
                                          <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">(pour information)</span></b></p>
                                          
                                          </td>
                                       
                                       
                                       <td width="17.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:37.6pt" rowspan="1" colspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Libellé </span></b></p>
                                          
                                          </td>
                                       
                                       
                                       <td width="12.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:37.6pt" rowspan="1" colspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Prévisions (a) </span></b></p>
                                          
                                          </td>
                                       
                                       
                                       <td width="12.8%" colspan="2" valign="top" style="border:none; border-right:solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt; height:37.6pt" rowspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Réalisations – titres émis (b) </span></b></p>
                                          
                                          </td>
                                       
                                       
                                       <td width="12.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:37.6pt" rowspan="1" colspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taux de réalisation (b/a)</span></b></p>
                                          
                                          </td>
                                       
                                       
                                       <td width="12.8%" valign="top" style="border:none;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:37.6pt" rowspan="1" colspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Restes à réaliser (3) </span></b></p>
                                          
                                          </td>
                                       
                                       
                                       <td width="13.4%" colspan="2" valign="top" style="border:none; border-right:double black 2.25pt;padding: 0cm 3.55pt 1.5pt 3.55pt; height:37.6pt" rowspan="1">
                                          
                                          
                                          
                                          <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Cumul des réalisations (4)</span></b></p>
                                          
                                          </td>
                                       </tr>
                                    
                                    </thead>
                                 
                                 
                                 <tr>
                                    
                                    
                                    <td width="35.2%" colspan="3" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:double black 2.25pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">RECETTES</span></b></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECINVOP')]/n:CredOuv/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="1.5%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:none; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left"><b><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">C</span></b></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="11.3%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECINVOP')]/n:MtReal/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border:solid black 1.0pt; border-left:none;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECINVOPTXREAL')]/n:TxReal3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif"></span></b><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECINVOP')]/n:MtRAR3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="2.6%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:none; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left"><b><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">D</span></b></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="10.8%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECINVOP')]/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    </tr>
                                 
                                 
                                 <tr>
                                    
                                    <xsl:variable name="varOdm16" select="$varOdm15[(starts-with(./n:Nature/@V, '13'))]"></xsl:variable>
                                    
                                    
                                    <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">Total chapitre 13</span></b></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="23.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '13' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm16/n:CredOuv/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm16/n:MtReal/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECINVOP13')]/n:TxReal3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm16/n:MtRAR3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="13.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm16/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    </tr>
                                 
                                 
                                 <xsl:variable name="varOdm17">
                                    
                                    
                                    <xsl:for-each select="distinct-values($varOdm15[(starts-with(./n:Nature/@V, '13'))]/n:Nature/@V)">
                                       
                                       
                                       <xsl:sort select="."></xsl:sort>
                                       
                                       
                                       <xsl:variable name="codeBoucle" select="."></xsl:variable>
                                       
                                       <xsl:variable name="ligne" select="$varOdm15[(./n:Nature/@V=$codeBoucle) and (starts-with(./n:Nature/@V, '13'))]"></xsl:variable>
                                       
                                       
                                       <xsl:if test="$ligne">
                                          
                                          
                                          <tr style="height:5.6pt">
                                             
                                             
                                             <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoHeader" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">
                                                      
                                                      <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                                </td>
                                             
                                             
                                             <td width="23.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black">
                                                      
                                                      <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black"></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:CredOuv/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtReal/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#BFBFBF;padding:0cm 3.55pt 0cm 3.55pt;height:5.6pt" rowspan="1" colspan="1"> </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="13.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:5.6pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             </tr>
                                          </xsl:if>
                                       </xsl:for-each>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:variable name="varOdm18">
                                    
                                    
                                    <xsl:choose>
                                       
                                       
                                       <xsl:when test="count($varOdm17/*) = 0">
                                          
                                          
                                          <tr class=" #tech#">
                                             
                                             
                                             <td height="1px" width="11.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="23.6%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="13.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             </tr>
                                          </xsl:when>
                                       
                                       
                                       <xsl:otherwise>
                                          
                                          
                                          <xsl:sequence select="$varOdm17"></xsl:sequence>
                                          </xsl:otherwise>
                                       </xsl:choose>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:call-template name="table:processRowBorders">
                                    
                                    
                                    <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                                    
                                    
                                    <xsl:with-param name="rows" select="$varOdm18/xhtml:tr"></xsl:with-param>
                                    </xsl:call-template>
                                 
                                 
                                 <tr>
                                    
                                    <xsl:variable name="varOdm19" select="$varOdm15[(starts-with(./n:Nature/@V, '16'))]"></xsl:variable>
                                    
                                    
                                    <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">Total chapitre 16</span></b></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="23.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '16' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm19/n:CredOuv/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm19/n:MtReal/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECINVOP16')]/n:TxReal3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm19/n:MtRAR3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="13.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm19/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    </tr>
                                 
                                 
                                 <xsl:variable name="varOdm20">
                                    
                                    
                                    <xsl:for-each select="distinct-values($varOdm15[(starts-with(./n:Nature/@V, '16'))]/n:Nature/@V)">
                                       
                                       
                                       <xsl:sort select="."></xsl:sort>
                                       
                                       
                                       <xsl:variable name="codeBoucle" select="."></xsl:variable>
                                       
                                       <xsl:variable name="ligne" select="$varOdm15[(./n:Nature/@V=$codeBoucle) and (starts-with(./n:Nature/@V, '16'))]"></xsl:variable>
                                       
                                       
                                       <xsl:if test="$ligne">
                                          
                                          
                                          <tr style="height:7.3pt">
                                             
                                             
                                             <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                                </td>
                                             
                                             
                                             <td width="23.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black">
                                                      
                                                      <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black"></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:CredOuv/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtReal/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#BFBFBF;padding:0cm 3.55pt 0cm 3.55pt;height:7.3pt" rowspan="1" colspan="1"> </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="13.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             </tr>
                                          </xsl:if>
                                       </xsl:for-each>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:variable name="varOdm21">
                                    
                                    
                                    <xsl:choose>
                                       
                                       
                                       <xsl:when test="count($varOdm20/*) = 0">
                                          
                                          
                                          <tr class=" #tech#">
                                             
                                             
                                             <td height="1px" width="11.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="23.6%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="13.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             </tr>
                                          </xsl:when>
                                       
                                       
                                       <xsl:otherwise>
                                          
                                          
                                          <xsl:sequence select="$varOdm20"></xsl:sequence>
                                          </xsl:otherwise>
                                       </xsl:choose>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:call-template name="table:processRowBorders">
                                    
                                    
                                    <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                                    
                                    
                                    <xsl:with-param name="rows" select="$varOdm21/xhtml:tr"></xsl:with-param>
                                    </xsl:call-template>
                                 
                                 
                                 <tr style="height:7.3pt">
                                    
                                    <xsl:variable name="varOdm22" select="$varOdm15[(starts-with(./n:Nature/@V, '20'))]"></xsl:variable>
                                    
                                    
                                    <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">Total chapitre 20</span></b></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="23.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '20' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm22/n:CredOuv/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm22/n:MtReal/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECINVOP20')]/n:TxReal3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm22/n:MtRAR3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="13.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm22/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    </tr>
                                 
                                 
                                 <xsl:variable name="varOdm23">
                                    
                                    
                                    <xsl:for-each select="distinct-values($varOdm15[(starts-with(./n:Nature/@V, '20'))]/n:Nature/@V)">
                                       
                                       
                                       <xsl:sort select="."></xsl:sort>
                                       
                                       
                                       <xsl:variable name="codeBoucle" select="."></xsl:variable>
                                       
                                       <xsl:variable name="ligne" select="$varOdm15[(./n:Nature/@V=$codeBoucle) and (starts-with(./n:Nature/@V, '20'))]"></xsl:variable>
                                       
                                       
                                       <xsl:if test="$ligne">
                                          
                                          
                                          <tr style="height:7.3pt">
                                             
                                             
                                             <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">
                                                      
                                                      <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                                </td>
                                             
                                             
                                             <td width="23.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black">
                                                      
                                                      <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black"></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:CredOuv/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtReal/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#BFBFBF;padding:0cm 3.55pt 0cm 3.55pt;height:7.3pt" rowspan="1" colspan="1"> </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="13.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             </tr>
                                          </xsl:if>
                                       </xsl:for-each>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:variable name="varOdm24">
                                    
                                    
                                    <xsl:choose>
                                       
                                       
                                       <xsl:when test="count($varOdm23/*) = 0">
                                          
                                          
                                          <tr class=" #tech#" style="height:7.3pt">
                                             
                                             
                                             <td height="1px" width="11.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="23.6%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="13.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             </tr>
                                          </xsl:when>
                                       
                                       
                                       <xsl:otherwise>
                                          
                                          
                                          <xsl:sequence select="$varOdm23"></xsl:sequence>
                                          </xsl:otherwise>
                                       </xsl:choose>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:call-template name="table:processRowBorders">
                                    
                                    
                                    <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                                    
                                    
                                    <xsl:with-param name="rows" select="$varOdm24/xhtml:tr"></xsl:with-param>
                                    </xsl:call-template>
                                 
                                 
                                 <tr style="height:7.3pt">
                                    
                                    <xsl:variable name="varOdm25" select="$varOdm15[(starts-with(./n:Nature/@V, '21'))]"></xsl:variable>
                                    
                                    
                                    <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">Total chapitre 21</span></b></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="23.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '21' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm25/n:CredOuv/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm25/n:MtReal/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECINVOP21')]/n:TxReal3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm25/n:MtRAR3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="13.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm25/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    </tr>
                                 
                                 
                                 <xsl:variable name="varOdm26">
                                    
                                    
                                    <xsl:for-each select="distinct-values($varOdm15[(starts-with(./n:Nature/@V, '21'))]/n:Nature/@V)">
                                       
                                       
                                       <xsl:sort select="."></xsl:sort>
                                       
                                       
                                       <xsl:variable name="codeBoucle" select="."></xsl:variable>
                                       
                                       <xsl:variable name="ligne" select="$varOdm15[(./n:Nature/@V=$codeBoucle) and (starts-with(./n:Nature/@V, '21'))]"></xsl:variable>
                                       
                                       
                                       <xsl:if test="$ligne">
                                          
                                          
                                          <tr style="height:7.3pt">
                                             
                                             
                                             <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                                </td>
                                             
                                             
                                             <td width="23.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black">
                                                      
                                                      <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black"></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:CredOuv/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtReal/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#BFBFBF;padding:0cm 3.55pt 0cm 3.55pt;height:7.3pt" rowspan="1" colspan="1"> </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="13.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             </tr>
                                          </xsl:if>
                                       </xsl:for-each>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:variable name="varOdm27">
                                    
                                    
                                    <xsl:choose>
                                       
                                       
                                       <xsl:when test="count($varOdm26/*) = 0">
                                          
                                          
                                          <tr class=" #tech#" style="height:7.3pt">
                                             
                                             
                                             <td height="1px" width="11.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="23.6%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="13.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             </tr>
                                          </xsl:when>
                                       
                                       
                                       <xsl:otherwise>
                                          
                                          
                                          <xsl:sequence select="$varOdm26"></xsl:sequence>
                                          </xsl:otherwise>
                                       </xsl:choose>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:call-template name="table:processRowBorders">
                                    
                                    
                                    <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                                    
                                    
                                    <xsl:with-param name="rows" select="$varOdm27/xhtml:tr"></xsl:with-param>
                                    </xsl:call-template>
                                 
                                 
                                 <tr style="height:7.3pt">
                                    
                                    <xsl:variable name="varOdm28" select="$varOdm15[(starts-with(./n:Nature/@V, '22'))]"></xsl:variable>
                                    
                                    
                                    <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">Total chapitre 22</span></b></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="23.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '22' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm28/n:CredOuv/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm28/n:MtReal/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECINVOP22')]/n:TxReal3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm28/n:MtRAR3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="13.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm28/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    </tr>
                                 
                                 
                                 <xsl:variable name="varOdm29">
                                    
                                    
                                    <xsl:for-each select="distinct-values($varOdm15[(starts-with(./n:Nature/@V, '22'))]/n:Nature/@V)">
                                       
                                       
                                       <xsl:sort select="."></xsl:sort>
                                       
                                       
                                       <xsl:variable name="codeBoucle" select="."></xsl:variable>
                                       
                                       <xsl:variable name="ligne" select="$varOdm15[(./n:Nature/@V=$codeBoucle) and (starts-with(./n:Nature/@V, '22'))]"></xsl:variable>
                                       
                                       
                                       <xsl:if test="$ligne">
                                          
                                          
                                          <tr style="height:7.3pt">
                                             
                                             
                                             <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                                </td>
                                             
                                             
                                             <td width="23.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black">
                                                      
                                                      <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black"></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:CredOuv/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtReal/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#BFBFBF;padding:0cm 3.55pt 0cm 3.55pt;height:7.3pt" rowspan="1" colspan="1"> </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="13.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             </tr>
                                          </xsl:if>
                                       </xsl:for-each>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:variable name="varOdm30">
                                    
                                    
                                    <xsl:choose>
                                       
                                       
                                       <xsl:when test="count($varOdm29/*) = 0">
                                          
                                          
                                          <tr class=" #tech#" style="height:7.3pt">
                                             
                                             
                                             <td height="1px" width="11.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="23.6%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="13.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             </tr>
                                          </xsl:when>
                                       
                                       
                                       <xsl:otherwise>
                                          
                                          
                                          <xsl:sequence select="$varOdm29"></xsl:sequence>
                                          </xsl:otherwise>
                                       </xsl:choose>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:call-template name="table:processRowBorders">
                                    
                                    
                                    <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                                    
                                    
                                    <xsl:with-param name="rows" select="$varOdm30/xhtml:tr"></xsl:with-param>
                                    </xsl:call-template>
                                 
                                 
                                 <tr style="height:7.3pt">
                                    
                                    <xsl:variable name="varOdm31" select="$varOdm15[(starts-with(./n:Nature/@V, '23'))]"></xsl:variable>
                                    
                                    
                                    <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">Total chapitre 23</span></b></p>
                                       
                                       </td>
                                    
                                    
                                    <td width="23.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '23' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><b><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif;color:black">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm31/n:CredOuv/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm31/n:MtReal/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='GRECINVOP23')]/n:TxReal3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm31/n:MtRAR3112/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    
                                    
                                    <td width="13.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><b><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                
                                                <xsl:call-template name="num:number">
                                                   
                                                   <xsl:with-param name="num" select="$varOdm31/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                   </xsl:call-template></span></b></p>
                                       </td>
                                    </tr>
                                 
                                 
                                 <xsl:variable name="varOdm32">
                                    
                                    
                                    <xsl:for-each select="distinct-values($varOdm15[(starts-with(./n:Nature/@V, '23'))]/n:Nature/@V)">
                                       
                                       
                                       <xsl:sort select="."></xsl:sort>
                                       
                                       
                                       <xsl:variable name="codeBoucle" select="."></xsl:variable>
                                       
                                       <xsl:variable name="ligne" select="$varOdm15[(./n:Nature/@V=$codeBoucle) and (starts-with(./n:Nature/@V, '23'))]"></xsl:variable>
                                       
                                       
                                       <xsl:if test="$ligne">
                                          
                                          
                                          <tr style="height:7.3pt">
                                             
                                             
                                             <td width="11.6%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                                </td>
                                             
                                             
                                             <td width="23.6%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left; line-height:115%"><span style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black">
                                                      
                                                      <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span><span lang="FR" style="font-size:7.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif;color:black"></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right; line-height:115%"><span lang="FR" style="font-size:7.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:CredOuv/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtReal/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; background:#BFBFBF;padding:0cm 3.55pt 0cm 3.55pt;height:7.3pt" rowspan="1" colspan="1"> </td>
                                             
                                             
                                             <td width="12.8%" valign="top" style="border-top:none;border-left:none; border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1" colspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             
                                             
                                             <td width="13.4%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;height:7.3pt" rowspan="1">
                                                
                                                
                                                <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:7.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                                      
                                                      <xsl:call-template name="num:number">
                                                         
                                                         <xsl:with-param name="num" select="$ligne/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                                         </xsl:call-template></span></p>
                                                </td>
                                             </tr>
                                          </xsl:if>
                                       </xsl:for-each>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:variable name="varOdm33">
                                    
                                    
                                    <xsl:choose>
                                       
                                       
                                       <xsl:when test="count($varOdm32/*) = 0">
                                          
                                          
                                          <tr class=" #tech#" style="height:7.3pt">
                                             
                                             
                                             <td height="1px" width="11.6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="23.6%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="12.8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             
                                             
                                             <td height="1px" width="13.4%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;"></td>
                                             </tr>
                                          </xsl:when>
                                       
                                       
                                       <xsl:otherwise>
                                          
                                          
                                          <xsl:sequence select="$varOdm32"></xsl:sequence>
                                          </xsl:otherwise>
                                       </xsl:choose>
                                    </xsl:variable>
                                 
                                 
                                 <xsl:call-template name="table:processRowBorders">
                                    
                                    
                                    <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                                    
                                    
                                    <xsl:with-param name="rows" select="$varOdm33/xhtml:tr"></xsl:with-param>
                                    </xsl:call-template>
                                 </table>
                              </xsl:variable>
                           
                           
                           <xsl:call-template name="table:outputTable">
                              
                              
                              <xsl:with-param name="table" select="$varOdmTmpTab4"></xsl:with-param>
                              </xsl:call-template>
                           
                           </div>
                        
                        
                        
                        <p class="MsoNormal" style="margin-right:2.55pt"><span lang="FR" style="font-size: 8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
                        
                        
                        
                        <xsl:variable name="varOdmTmpTab5">
                           
                           
                           <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                              
                              
                              <tr height="0" class="#tech# #fixWidths#">
                                 
                                 
                                 <td width="38.5%" style="border:none" rowspan="1" colspan="1"></td>
                                 
                                 
                                 <td width="5.1%" style="border:none" rowspan="1" colspan="1"></td>
                                 
                                 
                                 <td width="24.4%" style="border:none" rowspan="1" colspan="1"></td>
                                 
                                 
                                 <td width="5.1%" style="border:none" rowspan="1" colspan="1"></td>
                                 
                                 
                                 <td width="26.8%" style="border:none" rowspan="1" colspan="1"></td>
                                 </tr>
                              
                              
                              <tr>
                                 
                                 
                                 <td width="38.5%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                    
                                    
                                    
                                    <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Solde du financement (5)</span></b></p>
                                    
                                    </td>
                                 
                                 
                                 <td width="29.4%" colspan="2" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                    
                                    
                                    
                                    <p class="MsoHeader" style="margin-right:2.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Pour l’exercice</span></b></p>
                                    
                                    </td>
                                 
                                 
                                 <td width="32%" colspan="2" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1">
                                    
                                    
                                    
                                    <p class="MsoHeader" style="margin-right:2.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">En cumulé</span></b></p>
                                    
                                    </td>
                                 </tr>
                              
                              
                              <tr>
                                 
                                 
                                 <td width="38.5%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                    
                                    
                                    
                                    <p class="MsoNormal" style="margin-right:2.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Recettes – dépenses</span></b></p>
                                    
                                    </td>
                                 
                                 
                                 <td width="5.1%" valign="top" style="border:none;border-bottom:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                    
                                    
                                    
                                    <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">C-A</span></p>
                                    
                                    </td>
                                 
                                 
                                 <td width="24.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                    
                                    
                                    <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='SOLDEINVOP')]/n:MtReal/@V"></xsl:with-param>
                                             </xsl:call-template></span></p>
                                    </td>
                                 
                                 
                                 <td width="5.1%" valign="top" style="border:none;border-bottom:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                    
                                    
                                    
                                    <p class="MsoNormal" align="left" style="margin-right:2.55pt;text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">D-B</span></p>
                                    
                                    </td>
                                 
                                 
                                 <td width="26.8%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding: 0cm 3.55pt 1.5pt 3.55pt;" rowspan="1" colspan="1">
                                    
                                    
                                    <p class="MsoNormal" align="right" style="margin-right:2.55pt;text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                          
                                          <xsl:call-template name="num:number">
                                             
                                             <xsl:with-param name="num" select="$varOdm1[(n:Groupe/@V='SOLDEINVOP')]/n:MtSup[(@Code='MtOpeCumul')]/@V"></xsl:with-param>
                                             </xsl:call-template></span></p>
                                    </td>
                                 </tr>
                              </table>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:outputTable">
                           
                           
                           <xsl:with-param name="table" select="$varOdmTmpTab5"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        
                        <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
                        
                        
                        
                        <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(1) Ouvrir une page par chapitre d’opération.</span></p>
                        
                        
                        
                        <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(2) Détailler les articles utilisés conformément au plan de comptes.</span></p>
                        
                        
                        
                        <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(3) Dépenses engagées non mandatées ou recettes justifiées non titrées.</span></p>
                        
                        
                        
                        <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(4) Réalisations antérieures + réalisations de l’exercice.</span></p>
                        
                        
                        
                        <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(5) Indiquer le signe algébrique.</span></p>
                        
                        </div>
                     
                     </xsl:for-each>
                  </xsl:otherwise>
               </xsl:choose>
            
            
            <div id="footer">
               
               <p xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" class="MsoNormal"><span style="font-size:8.0pt;line-height:115%">
                     
                     <xsl:if test="$HTML_OUTPUT_FORMAT">
                        
                        <xsl:variable name="link1" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"></xsl:variable>
                        
                        <xsl:variable name="link2" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"></xsl:variable>
                        
                        <xsl:variable name="link3" select="'images/return.png'"></xsl:variable>
                        
                        <xsl:variable name="link4" select="'Accueil'"></xsl:variable>
                        
                        <xsl:variable name="link5" select="$link1"></xsl:variable>
                        
                        <xsl:variable name="link6" select="$link2"></xsl:variable>
                        
                        <xsl:call-template name="com:lienOutputImage">
                           
                           <xsl:with-param name="Param_0" select="'images/return.png'"></xsl:with-param>
                           
                           <xsl:with-param name="Param_1" select="$link3"></xsl:with-param>
                           
                           <xsl:with-param name="Param_2" select="$link4"></xsl:with-param>
                           
                           <xsl:with-param name="Param_3" select="$link5"></xsl:with-param>
                           
                           <xsl:with-param name="Param_4" select="$link6"></xsl:with-param>
                           </xsl:call-template>
                        </xsl:if></span></p>
               </div>
            </body>
         
         </html></xsl:template></xsl:stylesheet>