<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:data="http://odm-budgetaire.org/data" xmlns:date="http://exslt.org/dates-and-times" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../number.xsl"></xsl:import><xsl:import href="../../date.xsl"></xsl:import><xsl:import href="../../table.xsl"></xsl:import><xsl:import href="../../style.xsl"></xsl:import><xsl:import href="../../lien.xsl"></xsl:import><xsl:import href="../../commons/constants.xsl"></xsl:import><xsl:import href="../../commons/fonctions.xsl"></xsl:import><xsl:import href="../../commons/templates.xsl"></xsl:import><xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param><xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="dcfu:CompteFinancierUnique"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docXHTML.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docPDF.css" />
      
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"Arial Unicode MS";
  panose-1:2 11 6 4 2 2 2 2 2 4;}
@font-face
  {font-family:"Liberation Serif";
  panose-1:2 2 6 3 5 4 5 2 3 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:"\@Arial Unicode MS";
  panose-1:2 11 6 4 2 2 2 2 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.MsoBodyText, li.MsoBodyText, div.MsoBodyText
  {
  margin-top:0cm;
  margin-right:0cm;
  margin-bottom:7.0pt;
  margin-left:0cm;
  line-height:120%;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
span.CorpsdetexteCar
  {
  
  font-family:"Liberation Serif",serif;}
p.Contenudetableau, li.Contenudetableau, div.Contenudetableau
  {
  margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.Standard, li.Standard, div.Standard
  {
  margin:0cm;
  margin-bottom:.0001pt;
  text-autospace:ideograph-other;
  font-size:12.0pt;
  font-family:"Liberation Serif",serif;}
.MsoChpDefault
  {font-family:"Arial",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style>
   </head>
   <body id="ETAT_ARRESIGN" lang="FR"><div id="header">
         <xsl:variable name="tableau1"><table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border:none"><tr><td width="75%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size: 10.0pt;font-family:&#34;Arial&#34;,sans-serif"><xsl:variable name="text1"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@CodeBC)"/></xsl:variable><xsl:variable name="text2"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Libelle)"/></xsl:variable><xsl:value-of select="concat ($text1, ' ', '-', ' ', $text2)" /></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p class="MsoNormal" align="right" style="text-align:right;punctuation-wrap:simple"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif"><xsl:variable name="text3"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V)"/></xsl:variable><xsl:value-of select="concat ('Exercice', ' ', $text3)" /></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="tableau2"><table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style=""><tr><td width="90%" valign="top" style="border:solid black 1.0pt; border-right:none;padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><b><span style="font-size:12.0pt">V – ARRETE ET SIGNATURES</span></b></p>
               </td><td width="10%" valign="top" style="border:solid black 1.0pt; padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><b><span style="font-size:12.0pt">V</span></b></p>
               </td></tr><tr><td width="90%" valign="top" style="border-top:none;border-left: solid black 1.0pt;border-bottom:solid black 1.0pt;border-right:none; padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><b>ARRETE ET SIGNATURES</b></p>
               </td><td width="10%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><b>A</b></p>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><b><span style="font-size:8.0pt"> </span></b></p>
         <p class="MsoNormal"><span style="font-size:8.0pt"><xsl:variable name="text4"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Edition/@DateEdition)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:value-of select="concat ('Date d’édition :', ' ', $text4)" /></span></p>
         <p class="MsoNormal"><span style="font-size:8.0pt"> </span></p>
         <xsl:variable name="tableau3"><table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style=""><tr style="height:1.25pt"><td width="38.8%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt; height:1.25pt" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt">Comptable(s)</span></b></p>
               </td><td width="3.1%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt; height:1.25pt" rowspan="1" colspan="1"> </td><td width="58.2%" colspan="3" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt; height:1.25pt" rowspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt">Ayant exercé au cours de la gestion</span></b></p>
               </td></tr><xsl:for-each select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Gestion"><xsl:variable name="bclBloc_DCPT_ETT_Ge_1" select="."></xsl:variable><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="38.8%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p class="MsoNormal"><span style="font-size:8.0pt"><xsl:value-of select="distinct-values($bclBloc_DCPT_ETT_Ge_1/@NomComptable)"/></span></p></td><td width="3.1%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><span style="font-size:8.0pt">du</span></p>
               </td><td width="23.5%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p class="MsoNormal"><span lang="EN-US" style="font-size:8.0pt"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($bclBloc_DCPT_ETT_Ge_1/@DateDebutGestion)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td><td width="3.1%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><span style="font-size:8.0pt">au</span></p>
               </td><td width="29.6%" valign="top" style="padding: 2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p class="MsoNormal"><span style="font-size:8.0pt"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($bclBloc_DCPT_ETT_Ge_1/@DateFinGestion)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template> <xsl:variable name="text5"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos[(./dc:Gestion=$bclBloc_DCPT_ETT_Ge_1)]/dc:Edition/@DateEdition)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:if test="not( $bclBloc_DCPT_ETT_Ge_1/@DateFinGestion)"><xsl:value-of select="$text5" /></xsl:if></span></p></td></tr></xsl:for-each></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau3"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:8.0pt"> </span></p>
         <p class="MsoNormal"><span style="font-size:8.0pt">Vu et certifié par le comptable supérieur ou son délégué qui déclare que le présent
               compte est exact en ses résultats.</span></p>
         <p class="MsoNormal"><span style="font-size:8.0pt"> </span></p>
         <xsl:variable name="tableau4"><table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border:none"><tr><td width="50.4%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p class="MsoNormal"><span style="font-size:8.0pt"> <u>Observations</u> : <xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable supérieur') and (not(./xad:SigningMode))]/xad:SigningComment)"/></span></p></td><td width="49.6%" valign="top" style="padding:0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"> </td></tr><tr><td width="50.4%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p class="MsoNormal"><b><span style="font-size:8.0pt"><xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable supérieur') and (not(./xad:SigningMode))]/xad:SignerIdentity/xad:SignerName)"/></span></b></p></td><td width="49.6%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt"><xsl:variable name="text6"><xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable supérieur') and (not(./xad:SigningMode))]/xad:SignatureProductionPlace/xad:RealSignPlace)"/></xsl:variable><xsl:value-of select="concat ('A', ' ', $text6)" /><xsl:variable name="text7"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable supérieur') and (not(./xad:SigningMode))]/xad:SigningTime)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:value-of select="concat (', le', ' ', $text7)" /></span></b></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau4"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:8.0pt"> </span></p>
         <p class="MsoNormal"><span style="font-size:8.0pt">Le comptable soussigné affirme véritable, sous les peines de droit, le présent compte.</span></p>
         <xsl:variable name="tableau5"><table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border:none"><tr><td width="49.4%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p class="MsoNormal"><span style="font-size:8.0pt"> <b><xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable assignataire') and (not(./xad:SigningMode))]/xad:SignerIdentity/xad:SignerName)"/></b></span></p></td><td width="50.6%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt"><xsl:variable name="text8"><xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable assignataire') and (not(./xad:SigningMode))]/xad:SignatureProductionPlace/xad:RealSignPlace)"/></xsl:variable><xsl:value-of select="concat ('A', ' ', $text8)" /><xsl:variable name="text9"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable assignataire') and (not(./xad:SigningMode))]/xad:SigningTime)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:value-of select="concat (', le', ' ', $text9)" /></span></b></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau5"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:8.0pt"> </span></p>
         <xsl:variable name="tableau6"><table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border:none"><tr><td width="100%" colspan="2" valign="top" style=" padding: 0cm 5.4pt 1.5pt 0cm;" rowspan="1"><p class="MsoNormal"><span style="font-size:8.0pt"> <xsl:variable name="text10"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Ordonnateur') and (not(./xad:SigningMode))]/xad:SigningDateVote)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:value-of select="concat ('Vu par l’ordonnateur ou son délégué qui certifie que le présent compte a été voté le', ' ', $text10, ' ', 'par l’organe délibérant.')" /></span></p></td></tr><tr><td width="47.5%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p class="MsoNormal"><b><span style="font-size:8.0pt"><xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Ordonnateur') and (not(./xad:SigningMode))]/xad:SignerIdentity/xad:SignerName)"/></span></b></p></td><td width="52.5%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt"><xsl:variable name="text11"><xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Ordonnateur') and (not(./xad:SigningMode))]/xad:SignatureProductionPlace/xad:RealSignPlace)"/></xsl:variable><xsl:value-of select="concat ('A', ' ', $text11)" /><xsl:variable name="text12"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Ordonnateur') and (not(./xad:SigningMode))]/xad:SigningTime)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:value-of select="concat (', le', ' ', $text12)" /></span></b></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau6"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:8.0pt"> </span></p>
         <xsl:variable name="tableau7"><table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border:none"><tr><td width="100%" colspan="2" valign="top" style=" padding: 0cm 5.4pt 1.5pt 0cm;" rowspan="1"><p class="MsoNormal"><span style="font-size:8.0pt"><b>Le comptable supérieur a forcé la validation du présent compte en l’absence de validation
                           par l’ordonnateur.</b></span></p><p class="MsoNormal"><u><span style="font-size:8.0pt">Observations</span></u><span style="font-size:8.0pt">: <xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SigningMode='F')]/xad:SigningComment)"/></span></p></td></tr><tr><td width="46.8%" valign="top" style="padding:0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"> </td><td width="53.2%" valign="top" style="padding: 0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"><p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt"><xsl:variable name="text13"><xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SigningMode='F')]/xad:SignatureProductionPlace/xad:RealSignPlace)"/></xsl:variable><xsl:value-of select="concat ('A', ' ', $text13)" /><xsl:variable name="text14"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SigningMode='F')]/xad:SigningTime)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:value-of select="concat (', le', ' ', $text14)" /></span></b></p></td></tr></table></xsl:variable><xsl:if test="$docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SigningMode='F')]/xad:SigningMode = 'F'"><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau7"></xsl:with-param></xsl:call-template></xsl:if>
         <p class="MsoNormal"><span style="font-size:8.0pt"> </span></p>
         <xsl:variable name="tableau8"><table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border:none"><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 0cm;" rowspan="1">
                  <p class="MsoNormal"><b><span style="font-size:8.0pt"></span></b><b><span style="font-size:8.0pt">Le comptable supérieur ayant signifié que le budget est inactif, l’ordonnateur est
                           dispensé de validation du présent compte. Il est ainsi validé automatiquement par
                           l’application, concomitamment à la validation du comptable assignataire.</span></b></p>
               </td></tr><tr><td width="51.8%" valign="top" style="padding:0cm 5.4pt 0cm 0cm" rowspan="1" colspan="1"> </td><td width="48.2%" valign="top" style="padding: 0cm 5.4pt 1.5pt 0cm;" rowspan="1" colspan="1"><p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt"><xsl:variable name="text15"><xsl:value-of select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable assignataire')]/xad:SignatureProductionPlace/xad:RealSignPlace)"/></xsl:variable><xsl:value-of select="concat ('A', ' ', $text15)" /><xsl:variable name="text16"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties[(./xad:SignerRole/xad:ClaimedRoles/xad:ClaimedRole='Comptable assignataire')]/xad:SigningTime)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_8'" /><xsl:value-of select="concat (', le', ' ', $text16)" /></xsl:element></span></b></p></td></tr></table></xsl:variable><xsl:if test="$docbudg/dcfu:Signatures/dcfu:PageSignatures/ds:Signature/ds:Object/xad:QualifyingProperties/xad:SignedProperties/xad:SignedSignatureProperties/xad:SigningMode = 'A'"><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau8"></xsl:with-param></xsl:call-template></xsl:if>
         <p class="MsoNormal"><span style="font-size:8.0pt"> </span></p>
      </div>
      <div id="footer">
         <p class="MsoNormal"><span style="font-size:8.0pt;line-height:115%"><xsl:if test="$HTML_OUTPUT_FORMAT"><xsl:variable name="link1" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link2" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link3" select="'images/return.png'"/><xsl:variable name="link4" select="'Accueil'"/><xsl:variable name="link5" select="$link1"/><xsl:variable name="link6" select="$link2"/><xsl:call-template name="com:lienOutputImage"><xsl:with-param name="Param_0" select="'images/return.png'" /><xsl:with-param name="Param_1" select="$link3" /><xsl:with-param name="Param_2" select="$link4" /><xsl:with-param name="Param_3" select="$link5" /><xsl:with-param name="Param_4" select="$link6" /></xsl:call-template></xsl:if></span></p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>