<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"/><xsl:import href="../../../../date.xsl"/><xsl:import href="../../../../table.xsl"/><xsl:import href="../../../../style.xsl"/><xsl:import href="../../../../lien.xsl"/><xsl:variable name="page-format" select="portrait"/><xsl:output encoding="UTF-8" method="xml" indent="yes"/><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"/><xsl:param name="nomenclaturePasEnrichie"/><xsl:variable name="nomenclature" select="document('libellePlanCompte.xml')/n:Nomenclature"/><xsl:variable name="data" select="document('libelleAffiche.xml')/data"/><xsl:variable name="isPrint" select="1"/><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"/><xsl:template match="/dcfu:CompteFinancierUnique"/><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
            <meta name="generator" content="ODM"/>
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css"/>
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css"/>
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:Wingdings;
  panose-1:5 0 0 0 0 0 0 0 0 0;}
@font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Tahoma;
  panose-1:2 11 6 4 3 5 4 4 2 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoBodyText3, li.MsoBodyText3, div.MsoBodyText3
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:8.0pt;
  font-family:"Times New Roman",serif;}
p.MsoAcetate, li.MsoAcetate, div.MsoAcetate
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:8.0pt;
  font-family:"Tahoma",sans-serif;}
p.MsoListParagraph, li.MsoListParagraph, div.MsoListParagraph
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpFirst, li.MsoListParagraphCxSpFirst, div.MsoListParagraphCxSpFirst
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpMiddle, li.MsoListParagraphCxSpMiddle, div.MsoListParagraphCxSpMiddle
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpLast, li.MsoListParagraphCxSpLast, div.MsoListParagraphCxSpLast
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
span.En-tteCar
  {
  }
span.PieddepageCar
  {
  }
span.TextedebullesCar
  {
  
  font-family:"Tahoma",sans-serif;}
span.Corpsdetexte3Car
  {
  
  font-family:"Times New Roman",serif;}
p.Standard, li.Standard, div.Standard
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-autospace:ideograph-other;
  font-size:12.0pt;
  font-family:"Times New Roman",serif;}
p.TableContents, li.TableContents, div.TableContents
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-autospace:ideograph-other;
  font-size:12.0pt;
  font-family:"Times New Roman",serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
 /* List Definitions */
 ol
  {margin-bottom:0in;}
ul
  {margin-bottom:0in;}
--&gt;
/**/
}</style></head>
         
         
         
      <body lang="EN-US"><xsl:variable name="Refer1">B1PRESCPTFIN</xsl:variable><xsl:variable name="Refer2" select="$docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:IdColl/@V"/><xsl:variable name="Refer3" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer1, '_', $Refer2, '_', $Refer3)"/></xsl:call-template><div id="header">
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &quot;Arial&quot;,&quot;sans-serif&quot;"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"/> - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"/> - <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"/>  - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"/></span></b></p>
               
            </div><div class="WordSection1">
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab1">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        <tr>
                           <td width="86%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">I – INFORMATIONS GENERALES ET SYNTHÉTIQUES</span></b></p>
                              
                           </td>
                           <td width="14%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">I</span></b></p>
                              
                           </td>
                        </tr>
                        <tr>
                           <td width="86%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">PRESENTATION GENERALE DU COMPTE FINANCIER – VUE D’ENSEMBLE</span></b></p>
                              
                           </td>
                           <td width="14%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">B1</span></b></p>
                              
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab1"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoHeader"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal" style="text-autospace:ideograph-other;vertical-align:baseline"><b><span lang="FR" style="font-size:11.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab2">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        <tr height="0" class="#tech# #fixWidths#">
                           <td width="20.9%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="22.9%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="6.3%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="15.9%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="16.6%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="17.4%" style="border:none" rowspan="1" colspan="1"/>
                        </tr>
                        <tr style="height:15.55pt">
                           <td width="100%" colspan="6" style="border:double black 1.5pt; border-bottom:solid black 1.0pt;background:white;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:15.55pt" rowspan="1">
                              
                              <p class="MsoNormal" style="text-autospace:ideograph-other;vertical-align:baseline"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">Détermination du résultat cumulé à la fin de l’exercice N</span></b></p>
                              
                           </td>
                        </tr>
                        <tr style="height:15.55pt">
                           <td width="50.2%" colspan="3" style="border-top:none;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1"> </td>
                           <td width="15.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Investissement</span></p>
                              
                           </td>
                           <td width="16.6%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Fonctionnement</span></p>
                              
                           </td>
                           <td width="17.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; background:white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Total cumulé</span></p>
                              
                           </td>
                        </tr>
                        <tr>
                           <td width="20.9%" rowspan="3" style="border-top:none;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:white;padding:1.4pt 1.4pt 1.4pt 1.4pt" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">Recettes</span></p>
                              
                           </td>
                           <td width="22.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">Prévision budgétaire totale</span></p>
                              
                           </td>
                           <td width="6.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">A</span></p>
                              
                           </td>
                           <td width="15.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINV')]/n:CredOuv/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="16.6%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:CredOuv/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="17.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOT')]/n:CredOuv/@V"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr>
                           <td width="22.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif;color:black">Recettes réalisées (1)</span></p>
                              
                           </td>
                           <td width="6.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">B</span></p>
                              
                           </td>
                           <td width="15.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINV')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="16.6%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="17.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOT')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr>
                           <td width="22.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif;color:black">Restes à réaliser</span></p>
                              
                           </td>
                           <td width="6.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">C</span></p>
                              
                           </td>
                           <td width="15.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINV')]/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="16.6%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="17.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOT')]/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr>
                           <td width="20.9%" rowspan="3" style="border-top:none;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:white;padding:1.4pt 1.4pt 1.4pt 1.4pt" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">Dépenses</span></p>
                              
                           </td>
                           <td width="22.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif;color:black">Autorisation budgétaire totale</span></p>
                              
                           </td>
                           <td width="6.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">D</span></p>
                              
                           </td>
                           <td width="15.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXINV')]/n:CredOuv/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="16.6%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:CredOuv/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="17.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXTOT')]/n:CredOuv/@V"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr>
                           <td width="22.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif;color:black">Dépenses réalisées (1)</span></p>
                              
                           </td>
                           <td width="6.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">E</span></p>
                              
                           </td>
                           <td width="15.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXINV')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="16.6%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="17.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXTOT')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr>
                           <td width="22.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif;color:black">Restes à réaliser</span></p>
                              
                           </td>
                           <td width="6.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">F</span></p>
                              
                           </td>
                           <td width="15.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXINV')]/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="16.6%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXFON')]/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="17.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:1.4pt 1.4pt 1.4pt 1.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPEXTOT')]/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:16.3pt">
                           <td width="20.9%" style="border-top:none;border-left:double black 1.5pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">Différences entre les titres et les mandats</span></p>
                              
                           </td>
                           <td width="22.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif;color:black">Solde des réalisations de l’exercice (+/-)</span></p>
                              
                           </td>
                           <td width="6.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">G = B – E</span></p>
                              
                           </td>
                           <td width="15.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDEINVEX')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="16.6%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDEFONEX')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="17.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDEGLOBEX')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:15.55pt">
                           <td width="20.9%" style="border-top:none;border-left:double black 1.5pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">Résultats antérieurs reportés</span></p>
                              
                           </td>
                           <td width="22.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">Résultats antérieurs reportés (+/-)</span></p>
                              
                           </td>
                           <td width="6.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">H</span></p>
                              
                           </td>
                           <td width="15.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDE001')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="16.6%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDE002')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="17.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDE_RESULT_REPORTE')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:16.3pt">
                           <td width="20.9%" style="border-top:none;border-left:double black 1.5pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">Solde (investissement) ou résultat de clôture (fonctionnement)</span></p>
                              
                           </td>
                           <td width="22.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">Excédent /déficit</span></p>
                              
                           </td>
                           <td width="6.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">G + H</span></p>
                              
                           </td>
                           <td width="15.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDEINVTOT')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="16.6%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDEFONTOT')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="17.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDEGLOBAL')]/n:MtReal/@V"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:15.55pt">
                           <td width="20.9%" style="border-top:none;border-left:double black 1.5pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">Différence entre les restes à réaliser</span></p>
                              
                           </td>
                           <td width="22.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">Restes à réaliser (+/-)</span></p>
                              
                           </td>
                           <td width="6.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;background: white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">I = C - F</span></p>
                              
                           </td>
                           <td width="15.9%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDEINVTOT')]/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="16.6%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDEFONTOT')]/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="17.3%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:1.4pt 1.4pt 1.4pt 1.4pt;height:15.55pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDEGLOBAL')]/n:MtRAR3112/@V"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:16.3pt">
                           <td width="20.9%" style="border-top:none;border-left:double black 1.5pt; border-bottom:double black 1.5pt;border-right:solid black 1.0pt; background:white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">Résultat cumulé</span></p>
                              
                           </td>
                           <td width="22.9%" style="border-top:none;border-left:none; border-bottom:double black 1.5pt;border-right:solid black 1.0pt; background:white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">Excédent /déficit</span></p>
                              
                           </td>
                           <td width="6.3%" style="border-top:none;border-left:none; border-bottom:double black 1.5pt;border-right:solid black 1.0pt; background:white;padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family: &quot;Arial&quot;,sans-serif">G + H + I</span></p>
                              
                           </td>
                           <td width="15.9%" style="border-top:none;border-left:none; border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDEINVTOT')]/n:MtCumulCA/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="16.6%" style="border-top:none;border-left:none; border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDEFONTOT')]/n:MtCumulCA/@V"/></xsl:call-template></span></p>
                           </td>
                           <td width="17.3%" style="border-top:none;border-left:none; border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:1.4pt 1.4pt 1.4pt 1.4pt;height:16.3pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="left" style="text-align:left;layout-grid-mode:char; text-autospace:ideograph-other;vertical-align:baseline"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDEGLOBAL')]/n:MtCumulCA/@V"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab2"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal" style="text-align:justify;text-autospace:ideograph-other; vertical-align:baseline"><b><span style="font-size:11.0pt;font-family:&quot;Arial&quot;,sans-serif; color:#FF3333"> </span></b></p>
               
               <p class="MsoNormal" align="left" style="text-align:left;text-autospace:ideograph-other; vertical-align:baseline"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif; color:black">(1) Les recettes réalisées et les dépenses réalisées concernent les opérations réelles et les opérations d'ordre</span></p>
               
               <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 6.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
            </div></body></html>
   </xsl:template></xsl:stylesheet>